block('b-groups-list')(
    addJs()(function() {
        return {
            campaign: this.data.campaign,
            groupIds: this.ctx.groups.map(function(group) {
                return group.adgroup_id;
            })
        }
    }),

    def()(function() {
        var groupsList = [],
            data = this.data,
            campaign = data.campaign,
            campGroupType = u.beminize(campaign.mediaType || ''),
            requiredGroupLists = ({
                performance: ['performance_filters']
            })[campGroupType] ||
                ['phrases', 'retargetings', 'target_interests', 'relevance_match', 'dynamic_conditions'],
            isContextShowsTurnedOff = !!data.campaign.strategy.is_net_stop,
            groupModelName = this.ctx.groupModelName,
            groups = this.ctx.groups;

        if (data.FORM.wp) {
            groups = groups.filter(function(group) {
                return data.show_adgroups[group.adgroup_id];
            });
        }

        groups.forEach(function(group) {
            // на странице p-campaign данные по группам приходят в старом формате
            // если в группе есть и текстовые и графические баннеры, то показываем первый текстовый
            var banner = u._.isArray(group.banners) ?
                (u._.find(group.banners, {
                    ad_type: 'text'
                }) || group.banners[0]) :
                group,
                warning = isContextShowsTurnedOff && group.active_size == 0,
                retargetingWarning = !warning && isContextShowsTurnedOff && group.retargeting_size > 0,
                // выводить предупреждение если баннер графический и запрещены показы в сетях
                // графический первым не будет, если в группе будет ТГО
                netStopWarning = banner.ad_type === 'image_ad' && isContextShowsTurnedOff &&
                    group.statusActive === 'Yes',
                groupModelParams = {
                    id: group.modelId,
                    name: groupModelName
                },
                isPreviewEditable = group.cpm_banners_type === 'cpm_audio' ? !!(data.features_enabled_for_operator || {}).cpm_audio : true;

            groupsList.push({});

            groupsList.push({
                block: 'b-campaign-group',
                modelParams: groupModelParams,
                mods: {
                    adgroupId: group.modelId,
                    type: campGroupType,
                    platform: data.campaign.platform,
                    warning: warning ? 'yes' : '', //@todo: отрефакторить на один модификатор
                    'warning-net-stop': netStopWarning ? 'yes' : '',
                    'warning-retargeting': retargetingWarning ? 'yes' : '',
                    'warning-oversized-phrases': group && group.is_banner_oversized ? 'yes' : '',
                    'warning-phrase-exceed-max-length': group && +group.does_phrase_exceed_max_length ? 'yes' : '',
                    'warning-phrase-exceed-max-words': group && +group.does_phrase_exceed_max_words ? 'yes' : '',
                    'warning-phrase-exceed-max-minus-words-length': group &&
                        +group.does_phrase_exceed_minus_word_max_length ?
                            'yes' :
                            ''
                },
                isPreviewHasControls: this.ctx.isPreviewHasControls && isPreviewEditable,
                group: group,
                mix: [{
                    block: 'b-layout-table',
                    elem: 'row'
                }],
                content: [
                    {
                        elem: 'group',
                        modelParams: groupModelParams,
                        // Иначе не работают переопределения для элементов по модификатору блока
                        elemMods: {
                            type: campGroupType
                        },
                        mix: [
                            {
                                block: 'b-groups-list',
                                elem: 'banner'
                            },
                            {
                                block: 'b-layout-table',
                                elem: 'cell'
                            },
                            {
                                block: 'b-campaign-group',
                                elem: 'wrapper'
                            }
                        ],
                        group: group
                    },
                    {
                        elem: 'phrases',
                        elemMods: {
                            type: campGroupType,
                            empty: !requiredGroupLists.some(function(prop) {
                                return group[prop] && !!group[prop].length;
                            }) ? 'yes' : ''
                        },
                        mix: [{
                            block: 'b-layout-table',
                            elem: 'cell'
                        }],
                        group: group,
                        modelParams: groupModelParams
                    }
                ]
            });
        }, this);

        return applyNext({
            groupsList: groupsList
        });
    }),

    content()(function() {
        return [
            this.groupsList,
            this.ctx.help && {
                block: 'b-layout-table',
                elem: 'row',
                content: [
                    {
                        elem: 'cell'
                    },
                    {
                        elem: 'cell',
                        content: {
                            block: 'b-groups-list',
                            elem: 'help'
                        }
                    }
                ]
            }
        ];
    })
);
