BEM.DOM.decl('b-groups-list', {
    onSetMod: {
        js: function() {
            this.__self.instance = this;
            var clientFeaturesAll = u.consts('clientFeaturesAll'),
                isCreativeFreeInterface = clientFeaturesAll ? clientFeaturesAll.includes('CREATIVE_FREE_INTERFACE') : false,
                isSmartCampaign = this.params.campaign.mediaType === 'performance';

            if (isCreativeFreeInterface && isSmartCampaign) {
                this.smartGroupsPreviewModel = BEM.MODEL.create({ name: 'dm-smart-groups-preview' });
                this.smartGroupsPreviewModel.initFromApi(this.params.groupIds, this.params.campaign.cid);
            }
        }
    },

    destruct: function() {
        if (this.smartGroupsPreviewModel) {
            this.smartGroupsPreviewModel.destruct();
        }

        this.__base.apply(this);
    }
}, {

    /**
     * Инициализирует списки ключевых фраз для групп баннеров, указанных в groupIds
     * Если groupIds не передано - инициализирует списки для всех баннеров кампании
     * @param {Number[]|Number} [groupIds] - список id баннеров. Может быть массивом или строкой
     */
    initPhrasesLists: function(groupIds) {
        return this._initGroupControls('b-phrases-list', 'b-phrases-list-group', groupIds)
    },

    /**
     * Инициализирует списки фильтров для групп баннеров, указанных в groupIds
     * Если groupIds не передано - инициализирует списки для всех баннеров кампании
     * @param {Number[]|Number} [groupIds] - список id баннеров. Может быть массивом или строкой
     */
    initDynamicMediaFilters: function(groupIds) {
        return this._initGroupControls('b-feed-filters-table', 'b-feed-filters-group', groupIds)
    },

    /**
     * Инициализирует списки ключевых фраз/фильтров для групп баннеров, указанных в groupIds
     * Если groupIds не передано - инициализирует списки для всех баннеров кампании
     * @param {String} listName название блока со списком фраз/фильтров
     * @param {String} groupName название блока со группами фраз/фильтров
     * @param {Number[]|Number} [groupIds] - список id баннеров. Может быть массивом или строкой
     */
    _initGroupControls: function(listName, groupName, groupIds) {
        var blocks = this._getBlocks(listName);

        if (groupIds && !(groupIds instanceof Array)) groupIds = [groupIds];

        blocks.forEach(function(list) {
            if (!groupIds || groupIds.indexOf(+list.getMod('group-id')) !== -1) {
                list.findBlocksInside(groupName);
            }
        }, this);

        return this;
    },

    /**
     * Находит блоки всех списков фраз в кампании и кэширует их
     * @param {String} name
     * @returns {BEM[]}
     */
    _getBlocks: function(name) {
        this._blocksHash || (this._blocksHash = {});

        return (this._blocksHash[name] || (this._blocksHash[name] = this.instance.findBlocksInside(name)));
    }

});
