block('b-groups-set-autotargeting').mod('view', 'manual-beta')(

    extend()(function() {
        var strategy = this.ctx.strategy,
            platform = u.strategy.ALL,
            isSeparateBids = strategy.name === u.strategy.DIFFERENT_PLACES;

        if (strategy.is_search_stop) {
            platform = u.strategy.NET;
        }

        if (strategy.is_net_stop) {
            platform = u.strategy.SEARCH;
        }

        return {
            platform: platform,
            isSeparateBids: isSeparateBids
        };
    }),

    js()(function() {
        return {
            platform: this.platform,
            isSeparateBids: this.isSeparateBids
        }
    }),

    elem('comment').content()(function() {
        return iget2(
            'b-groups-set-autotargeting',
            'show-your-ads-with-automatic-targeting',
            'Показ ваших объявлений с автоматическим таргетингом'
        );
    }),

    elem('body').content()(function() {
        var platform = this.platform,
            isSeparateBids = this.isSeparateBids;

        return [
            platform === u.strategy.ALL && isSeparateBids && {
                elem: 'pane',
                elemMods: { platform: u.beminize(u.strategy.ALL) },
                content: [
                    iget2(
                        'b-groups-set-autotargeting',
                        'ogranichenie-stavki-search-network',
                        'Ограничение ставки на поиске {search} в сетях {network}',
                        {
                            search: {
                                block: 'input',
                                mods: { size: 's', clear: 'no' },
                                mix: [
                                    { block: 'b-groups-set-autotargeting', elem: 'price' },
                                    { block: 'b-hintable', js: true },
                                    {
                                        block: 'b-groups-set-autotargeting',
                                        elem: 'model-field',
                                        js: {
                                            name: 'price',
                                            type: 'input'
                                        }
                                    }
                                ],
                                content: {
                                    elem: 'control'
                                }
                            },
                            network: {
                                block: 'input',
                                mods: { size: 's', clear: 'no' },
                                mix: [
                                    { block: 'b-groups-set-autotargeting', elem: 'price-context' },
                                    { block: 'b-hintable', js: true },
                                    {
                                        block: 'b-groups-set-autotargeting',
                                        elem: 'model-field',
                                        js: {
                                            name: 'price_context',
                                            type: 'input'
                                        }
                                    }
                                ],
                                content: {
                                    elem: 'control'
                                }
                            }

                        }
                    )
                ]
            },
            platform !== u.strategy.NET && !isSeparateBids && {
                elem: 'pane',
                elemMods: { platform: u.beminize(u.strategy.SEARCH) },
                content: [
                    {
                        block: 'b-groups-set-autotargeting',
                        elem: 'label',
                        content: iget2(
                            'b-groups-set-autotargeting',
                            'ogranichenie-stavki',
                            'Ограничение ставки'
                        )
                    },
                    {
                        block: 'input',
                        mods: { size: 's', clear: 'no' },
                        mix: [
                            { block: 'b-groups-set-autotargeting', elem: 'price' },
                            { block: 'b-hintable', js: true },
                            {
                                block: 'b-groups-set-autotargeting',
                                elem: 'model-field',
                                js: {
                                    name: 'price',
                                    type: 'input'
                                }
                            }
                        ],
                        content: {
                            elem: 'control'
                        }
                    }
                ]
            },
            platform === u.strategy.NET && {
                elem: 'pane',
                elemMods: { platform: u.beminize(u.strategy.SEARCH) },
                content: [
                    {
                        block: 'b-groups-set-autotargeting',
                        elem: 'label',
                        content: iget2(
                            'b-groups-set-autotargeting',
                            'ogranichenie-stavki',
                            'Ограничение ставки'
                        )
                    },
                    {
                        block: 'input',
                        mods: { size: 's', clear: 'no' },
                        mix: [
                            { block: 'b-groups-set-autotargeting', elem: 'price-context' },
                            { block: 'b-hintable', js: true },
                            {
                                block: 'b-groups-set-autotargeting',
                                elem: 'model-field',
                                js: {
                                    name: 'price_context',
                                    type: 'input'
                                }
                            }
                        ],
                        content: {
                            elem: 'control'
                        }
                    }
                ]
            },
            {
                elem: 'autoprice-row',
                content: [
                    {
                        block: 'checkbox',
                        mix: [
                            { block: 'b-groups-set-autotargeting', elem: 'autoprice' },
                            {
                                block: 'b-groups-set-autotargeting',
                                elem: 'model-field',
                                js: {
                                    name: 'autoprice',
                                    type: 'checkbox'
                                }
                            }
                        ],
                        text: iget2(
                            'b-groups-set-autotargeting',
                            'rasschityva-avtomaticheski',
                            'Рассчитывать автоматически'
                        )
                    },
                    {
                        block: 'icon',
                        mix: { block: 'b-groups-set-autotargeting', elem: 'icon' },
                        mods: { 'size-12': 'info' }
                    }
                ]
            }
        ]
    })

);
