BEM.DOM.decl({ block: 'b-groups-set-autotargeting', modName: 'view', modVal: 'manual-beta' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            u.graspSelf.call(this, {
                _autoprice: 'checkbox on autoprice'
            });

            this.model.set('platform', this.params.platform);
            this._accept.delMod('disabled');

            this._subMan
                .on(this.model, 'price price_context', 'change', function(e, data) {
                    this._validate([data.field]);
                    this._accept.delMod('disabled');
                }, this);

            this.bindTo(this.elem('icon'), 'pointerover pointerout', this._onIconOverOut, this);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this.unbindFrom(this.elem('icon'), 'pointerover pointerout');

        this.__base.apply(this, arguments);
    },

    _onAccept: function() {
        if (this._validate()) {
            this.setMod('loading', 'yes');
            this._sendRequest(this._getData());
        }
    },

    /**
     * Отдает данные для отправки на сервер
     * @param {BEM.MODEL} group
     * @returns {{price: number}}
     * @private
     * @override
     */
    _getChangedData: function(group) {
        var platform = this.model.get('platform'),
            isSeparateBids = this.params.isSeparateBids,
            data = {};

        switch (platform) {
            case u.strategy.ALL:
                data.price = this._getPrice(group, 'price');
                if (isSeparateBids) {
                    data.price_context = this._getPrice(group, 'price_context');
                }
                break;
            case u.strategy.NET:
                data.price_context = this._getPrice(group, 'price_context');
                data.search_stop = 1;
                break;
            case u.strategy.SEARCH:
                data.price = this._getPrice(group, 'price');
                data.net_stop = 1;
                break;
        }

        return data;
    },

    /**
     * Получение цены.
     * Если стоит галочка "рассчитать автоматически" - считает 30й перцентиль
     * от ставки фраз всех выбранных групп, но не больше введенного пользователем ограничения
     * Если не стоит галочка - возвращает цену пользователя
     * @param {BEM.MODEL} group
     * @param {string} priceField
     * @returns {number}
     * @private
     */
    _getPrice: function(group, priceField) {
        var maxPrice = this.model.get(priceField),
            percentile,
            phrasesPrices = [],
            result;

        if (!this.model.get('autoprice')) return maxPrice;

        phrasesPrices = group.getPhrasesModels().map(function(phrase) {
            return phrase.get(priceField);
        });

        if (phrasesPrices.length === 0) {
            return maxPrice;
        }

        percentile = u['relevance-match'].calcPercentile(phrasesPrices, this.model.get('currency'));

        result = Math.min(maxPrice, percentile);

        if (result === 0) {
            result = u.currencies.getConst(this.model.get('currency'), 'MIN_PRICE');
        }

        return result;
    },

    /**
     * Валидирует ставку и выводит ошибки и предупреждения
     * @returns {boolean}
     * @private
     */
    _validate: function(validateFields) {
        var platform = this.model.get('platform'),
            isSeparateBids = this.params.isSeparateBids,
            pane = this.elem('pane'),
            result = true;

        if (!u._.isArray(validateFields)) {
            switch (platform) {
                case u.strategy.ALL:
                    validateFields = ['price'];
                    if (isSeparateBids) {
                        validateFields.push('price_context');
                    }
                    break;
                case u.strategy.NET:
                    validateFields = ['price_context'];
                    break;
                case u.strategy.SEARCH:
                    validateFields = ['price'];
                    break;
            }
        }

        validateFields.forEach(function(field) {
            var value = this.model.get(field),
                currency = this._campaign.get('currency'),
                bigRate = u.currencies.getConst(currency, 'BIG_RATE'),
                validationResult = this.model.validate(field),
                priceElem = this.findElem(pane, u.beminize(field)),
                input,
                hint;
            input = this.findBlockInside(priceElem, 'input');
            hint = this.findBlockInside(priceElem, 'b-hintable');

            if (validationResult.valid && value < bigRate) {
                input.delMod('warning');
                input.delMod('error');
                hint.hideHint();
            }

            if (validationResult.valid && value >= bigRate) {
                input.delMod('error');
                input.setMod('warning', 'yes');
                hint.setHintContent(iget2(
                    'b-groups-set-autotargeting',
                    'bolshaya-stavka',
                    'Обратите внимание, выставлена высокая цена'
                ));
            }

            if (validationResult.errors) {
                input.delMod('warning');
                input.setMod('error', 'yes');
                hint.setHintContent(BEMHTML.apply({
                    block: 'b-groups-set-autotargeting',
                    elem: 'hint-content',
                    content: validationResult.errors.map(function(error) {
                        return error.text + ' ';
                    })
                }));

                result && hint._showHint();

                result = false;
            }

        }, this);

        return result;
    },

    /**
     * Обработчик наведения/ухода с иконки
     * @param {Event} e
     * @private
     */
    _onIconOverOut: function(e) {
        if (e.type === 'pointerover') {
            this._showTooltip(e.data.domElem);
        } else {
            this._hideTooltip();
        }
    },

    /**
     * Показывает тултип про авторасчет ставки
     * @param {jQuery} elem
     * @private
     */
    _showTooltip: function(elem) {
        this._tipman || (this._tipman = BEM.create('tipman', {
            tipMods: { theme: 'normal' },
            popupDirections: ['right', 'bottom'],
            delay: 50
        }));

        this._tipman.show({
            owner: elem,
            content: iget2(
                'b-groups-set-autotargeting',
                'stavka-rasschitaetsya-avtomaticheski',
                'Ставка рассчитается автоматически, <br/>но не превысит ограничение ставки.'
            )
        });
    },

    /**
     * Прячет тултип про авторасчет ставки
     * @private
     */
    _hideTooltip: function() {
        this._tipman && this._tipman.hide();
    }

});
