block('b-groups-set-autotargeting')(

    content()(function() {
        var mixBlock = this.ctx.mixBlock,
            isAutoMod = (this.ctx.mods || {}).view === 'auto';

        return [
            {
                elem: 'header',
                mix: { block: mixBlock, elem: 'header' },
                tag: 'h2',
                content: iget2(
                    'b-groups-set-autotargeting',
                    'dobavit-autotargeting-k-gruppam',
                    'Добавить автотаргетинг к группам'
                )
            },
            {
                elem: 'comment',
                mix: [
                    { block: mixBlock, elem: isAutoMod ? 'row' : 'note' }
                ],
                content: [
                    iget2(
                        'b-groups-set-autotargeting',
                        'avtomaticheskii-pokaz-vashih-obyavlenii',
                        'Автоматический показ ваших объявлений по подходящим поисковым запросам'
                    ),
                    '.&ensp;',
                    {
                        block: 'link',
                        url: u.getCommonHelpUrl('/direct/impression-criteria/autotargeting.html'),
                        target: '_blank',
                        content: iget2('b-groups-set-autotargeting', 'detail', 'Подробнее')
                    }
                ]
            },
            {
                elem: 'spinner',
                elemMods: { hidden: 'yes' },
                mix: { block: mixBlock, elem: 'row' },
                content: {
                    block: 'spin2',
                    mods: { size: 'l', progress: 'yes' }
                }
            },
            {
                elem: 'body',
                mix: { block: mixBlock, elem: 'row' },
                strategy: this.ctx.strategy
            },
            {
                elem: 'footer',
                mix: { block: mixBlock, elem: 'footer' },
                content: [
                    { elem: 'accept' },
                    { elem: 'cancel' }
                ]
            }
        ]
    }),

    elem('accept').replace()(function() {
        return {
            block: 'button',
            mix: { block: 'b-groups-set-autotargeting', elem: 'accept' },
            mods: { theme: 'action', disabled: 'yes' },
            content: iget2('b-groups-set-autotargeting', 'sohranit', 'Сохранить')
        };
    }),

    elem('cancel').replace()(function() {
        return {
            block: 'button',
            mix: { block: 'b-groups-set-autotargeting', elem: 'cancel' },
            content: iget2('b-groups-set-autotargeting', 'otmena', 'Отмена')
        };
    })
);
