BEM.DOM.decl({ block: 'b-groups-set-autotargeting', baseBlock: 'i-glue' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            u.graspSelf.call(this, {
                _popup: 'popup outside',
                _accept: 'button on accept',
                _cancel: 'button on cancel',
                _spin: 'spin2 inside'
            });

            this._subMan = BEM.create('i-subscription-manager');
            this._subMan
                .on(this._accept, 'click', this._onAccept, this)
                .on(this._cancel, 'click', this._onCancel, this);

            this._campaign = BEM.MODEL.getOne(this.params.campModelParams);

            // выбираем только неархивные группы
            this._groups = this._campaign.getSelectedGroups().filter(function(group) {
                return group.get('archive') === 'No';
            });

            this.model.update({
                view: this.getMod('view'),
                currency: this._campaign.get('currency')
            });
        },

        loading: {
            yes: function() {
                this._accept.setMod('disabled', 'yes');
                this._accept.setText(iget2('b-groups-set-autotargeting', 'sohranyaetsya', 'Сохраняется...'));
                this.setMod(this.elem('body'), 'hidden', 'yes');
                this.delMod(this.elem('spinner'), 'hidden');
            },

            '': function() {
                this._accept.setText(iget2('b-groups-set-autotargeting', 'sohranit', 'Сохранить'));
                this.delMod(this.elem('body'), 'hidden');
                this.setMod(this.elem('spinner'), 'hidden', 'yes');
            }
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Обработка клика по отмене
     */
    _onCancel: function() {
        this._hidePopup();
    },

    /**
     * Обработка клика по кнопке сохранить
     */
    _onAccept: function() {
        this.setMod('loading', 'yes');
        this._sendRequest(this._getData());
    },

    /**
     * Прячет попап
     * @private
     */
    _hidePopup: function() {
        this._popup && this._popup.hide();
    },

    /**
     * Формирование данных для отправки на сервер
     * @returns {Object}
     * @private
     */
    _getData: function() {
        var changedData,
            groupId,
            relevanceMatchId,
            mainBid;

        return this._groups.reduce(function(res, group) {
            mainBid = this._getMainBid(group);
            changedData = this._getChangedData(group);
            groupId = group.get('adgroup_id');
            relevanceMatchId = group.getRelevanceMatchModel().get('bid_id');

            // 0 - bid_id нового автотаргетинга
            // если автотаргетинг был и выключен, у него есть bid_id
            if (relevanceMatchId === '0') {
                res[groupId] = { added: [changedData] };
            } else {
                res[groupId] = { edited: {}, main_bid: mainBid };
                res[groupId].edited[relevanceMatchId] = changedData;
            }

            return res;
        }.bind(this), {});
    },

    /**
     * Возвращает bid_id первого баннера группы
     * @param {BEM.MODEL} group - модель группы
     * @private
     */
    _getMainBid: function(group) {
        return group
            .get('banners')
            .getByIndex(0)
            .get('modelId');
    },

    /**
     * Получение изменений (переопределяется в модификаторах)
     * @private
     */
    _getChangedData: function() {},

    /**
     * Создание ajax-запроса
     * @returns {BEM}
     * @private
     */
    _getRequest: function() {
        return BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            cache: false,
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        });
    },

    /**
     * Обработка успешного ajax-запроса и вывод ошибок
     * @param {Object} data - данные об ошибках
     * @private
     */
    _onSuccess: function(data) {
        var fromTests = this.params.fromTests,
            errors = data.error || [],
            needConcatErrors = !data.success && !data.error,
            onlyArchiveErrors = !data.error,
            reducedErrors = {},
            mappedErrors = [];

        if (!data.success && !data.error) {
            reducedErrors = u._.reduce(
                data,
                function(res, error, groupNo) {
                    // в error лежат {error_codes: [], errors: []}
                    // при этом ошибку 8300 игнорируем, это архивные
                    // см. DIRECT-73797
                    var errors = error.errors || [],
                        codes = error.error_codes || {};

                    errors.forEach(function(errorText, errorIndex) {
                        var code = codes[errorIndex] || {},
                            e = res[code];

                        if (!e) {
                            res[code] = { text: errorText, groupNo: [groupNo] };
                        } else {
                            e.groupNo.push(groupNo);
                        }

                        if (+code !== 8300) {
                            onlyArchiveErrors = false;
                        }
                    });

                    return res;
                }, {});

            mappedErrors = u._.map(reducedErrors, function(error, code) {
                var groupNoText = error.groupNo.join(', ');
                // ошибку архивных заменяем на свою, потому что с бэка приходит всегда "Группы"
                if (+code === 8300) {
                    return u.pluralForms(iget2(
                        'b-groups-set-autotargeting',
                        'archive-grops',
                        '{Группа|Группы|Группы} объявлений № {groupsNo} находится в архиве - редактирование ставок невозможно.',
                        {
                            groupsNo: groupNoText
                        }
                    ), error.groupNo.length)
                } else {
                    return error.text;
                }
            });
        }
        // собираем ошибки на конкретных группах
        errors = needConcatErrors ?
            errors.concat(mappedErrors) :
            errors;

        if (errors && errors.length > 0) {
            this._showError(iget2(
                'b-groups-set-autotargeting',
                'stavki-ne-ustanocleny',
                'Ставки на автотаргетинг не установлены, так как произошли следующие ошибки: {errors}.',
                { errors: errors }
            ), function() {
                if (!fromTests && onlyArchiveErrors) location.href = location.href.split('#')[0];
            });
        } else {
            if (!fromTests && onlyArchiveErrors) location.href = location.href.split('#')[0];
        }
    },

    /**
     * Обработка ошибок ajax-запроса
     * @private
     */
    _onError: function() {
        this._showError(iget2(
            'b-groups-set-autotargeting',
            'neizvestnaya-oshibka',
            'Неизвестная ошибка. Попробуйте позднее'
        ));
    },

    /**
     * Отображает ошибки в попапе
     * @param {String} error текст ошибки
     * @param {Function} callback - колбэк
     * @private
     */
    _showError: function(error, callback) {
        BEM.blocks['b-user-dialog'].alert({
            message: error,
            onCancel: function() {
                this._hidePopup();
                callback && callback();
            },
            callbackCtx: this
        });
    },

    /**
     * Отправка запроса для изменения ставок
     * @param {Object} data - данные автотаргетинга, формат данных описан в .md-файле
     * @returns {Promise}
     * @private
     */
    _sendRequest: function(data) {
        var count = Object.keys(data).length,
            params = {
                cid: this._campaign.get('cid'),
                ulogin: u.consts('ulogin'),
                cmd: 'ajaxUpdateShowConditions',
                json_phrases: '{}',
                json_adgroup_retargetings: '{}',
                json_adgroup_target_interests: '{}',
                json_relevance_match: JSON.stringify(data)
            };

        this._getRequest().get(
            params,
            this._onSuccess.bind(this),
            this._onError.bind(this),
            { timeout: count * 20000 }
        );
    }

});
