# b-groups-set-autotargeting

Блок установки автотаргетинга на массовых действиях.
**NB! Автотаргетинг всегда 1 на группу**

## Вход и выход
Принимает
- данные модели группы (`name, id`)
- блок, который надо миксовать ко всем элементам (`blockMix`), если хочется использовать стили для элементов попапа от этого блока.
Используется `p-campaign`.

Отдает
ajax-запрос следующего формата:
``
cid:campaignId
ulogin:shurupkirov
cmd:ajaxUpdateShowConditions
json_phrases:{}
json_adgroup_retargetings:{}
json_adgroup_target_interests:{}
json_relevance_match:{"261383701":{"edited":{"10677643076":{"autobudgetPriority":5}},"main_bid":"281592920"},"743753920":{"added":[{"autobudgetPriority":5}]}}
``

## Формат данных для поля json_relevance_match
``
{
    groupId1: {                      // id группы
        edited: {                    // edited, если автотаргетинг уже есть у группы
            relevanceMatchBidId: {   // bid_id автотаргетинга
                price: 25            // выставленная пользователем цена
            }
        }
    },
    groupId2: {                      // added, если автотаргетинга нет
        added: [
            {
                price: 25           // для автоматических стратегий пишем autobudgetPriority: 1|3|5
            }
        ]
    }
}
``

## Модификаторы (`_view_manual, _view_auto`, `_view_manual-beta`)

### manual

Используется, если в кампании ручная стратегия.
Имеет 3 контрола:
- price: ограничение ставки, которое задает пользователь. Валидируется как поле ввода ставки: обязательное, имеет минимум
и максимум (зависят от валюты, для рубля это 30 коп и 2500 соотвтественно) и предупреждение о слишком большой ставке (500 руб. для рубля).
- autoprice: галочка, что ставку надо рассчитать как 30ый перцентиль от всех ставок на фразы выбранных групп. Описание
алогритма расчета можно найти здесь: https://wiki.yandex-team.ru/Direkt/TechnicalDesign/relevance-match/#izmenenijavjadre
- icon: иконка с тултипом про авторасчет

### manual-beta

Новый автотаргетинг, дает возможность включить автотаргетинг для сети, работает по принципу manual
Имеет 3 контрола:
- price/price_context: ограничение ставки, которое задает пользователь. Валидируется как поле ввода ставки: обязательное, имеет минимум
и максимум (зависят от валюты, для рубля это 30 коп и 2500 соотвтественно) и предупреждение о слишком большой ставке (500 руб. для рубля).
- autoprice: галочка, что ставку надо рассчитать как 30ый перцентиль от всех ставок на фразы выбранных групп. Описание
алогритма расчета можно найти здесь: https://wiki.yandex-team.ru/Direkt/TechnicalDesign/relevance-match/#izmenenijavjadre
- icon: иконка с тултипом про авторасчет

### auto

Используется, если в кампании автоматическая стратегия.
Имеет 1 контрол:
- priority: селект выбора приоритета. Имеет 3 значения: низкий (1), средний (3) и высокий (5). Не валидируется.

## Модель

Используется только для ручного отображения. В модели хранятся валюта, флаг авторасчета и модификатор и валидируется ставка (только для ручного)
