BEM.MODEL.decl('b-groups-set-autotargeting', {
    currency: {
        type: 'string',
        internal: true
    },
    view: {
        type: 'string',
        internal: true
    },
    autoprice: {
        type: 'boolean',
        default: false
    },
    platform: {
        type: 'enum',
        enum: [
            u.strategy.ALL,
            u.strategy.SEARCH,
            u.strategy.NET
        ],
        default: u.strategy.ALL
    },
    price: {
        type: 'rounded-number',
        validation: function() {
            var currency = this.get('currency'),
                maxPrice = u.currencies.getConst(currency, 'MAX_PRICE'),
                minPrice = u.currencies.getConst(currency, 'MIN_PRICE');

            return {
                rules: {
                    required: { text: iget2('b-groups-set-autotargeting', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом.') },
                    gte: {
                        value: maxPrice,
                        text: iget2(
                            'b-groups-set-autotargeting',
                            'maximalnaya-stavka',
                            'Ставка должна быть не больше {max}',
                            { max: u.currencies.formatSum(currency, maxPrice) }
                        )
                    },
                    lte: {
                        value: minPrice,
                        text: iget2(
                            'b-groups-set-autotargeting',
                            'minimalnaya-stavka',
                            'Ставка должна быть не меньше {min}',
                            { min: u.currencies.formatSum(currency, minPrice) }
                        )
                    }
                },
                needToValidate: function() {
                    switch (this.get('view')) {
                        case 'manual':
                            return true;
                        case 'manual-beta':
                            return [u.strategy.ALL, u.strategy.SEARCH].indexOf(this.get('platform') !== -1);
                        default:
                            return false;
                    }
                }
            };
        }
    },
    price_context: {
        type: 'rounded-number',
        validation: function() {
            var currency = this.get('currency'),
                maxPrice = u.currencies.getConst(currency, 'MAX_PRICE'),
                minPrice = u.currencies.getConst(currency, 'MIN_PRICE');

            return {
                rules: {
                    required: { text: iget2('b-groups-set-autotargeting', 'stavka-dolzhna-byt-chislom', 'Ставка должна быть числом.') },
                    gte: {
                        value: maxPrice,
                        text: iget2(
                            'b-groups-set-autotargeting',
                            'maximalnaya-stavka',
                            'Ставка должна быть не больше {max}',
                            { max: u.currencies.formatSum(currency, maxPrice) }
                        )
                    },
                    lte: {
                        value: minPrice,
                        text: iget2(
                            'b-groups-set-autotargeting',
                            'minimalnaya-stavka',
                            'Ставка должна быть не меньше {min}',
                            { min: u.currencies.formatSum(currency, minPrice) }
                        )
                    }
                },

                needToValidate: this.get('view') === 'manual-beta' &&
                    [u.strategy.ALL, u.strategy.NET].indexOf(this.get('platform')) !== -1
            };
        }
    }
});
