block('b-gurantee-letter')(

    js()(function() {
        return {
            bid: this.ctx.bid,
            isAgencyEmployee: this.ctx.isAgencyEmployee,
            defaultTopicId: 4 //интеллектуальная собственность
        };
    }),

    mode('guarantee-topics')(function() {
        return [
            {
                text: iget2('b-gurantee-letter', 'tovary-konstruktivno-shodnye-s', 'Товары, конструктивно сходные с оружием'),
                topicId: 6
            },
            {
                text: iget2('b-gurantee-letter', 'pirotehnika', 'Пиротехника'),
                topicId: 8
            },
        // { text: iget('Интеллектуальная собственность'), topicId: 4 },
            {
                text: iget2('b-gurantee-letter', 'tovary-i-uslugi-ne', 'Товары и услуги, не относящиеся к медицине'),
                topicId: 5
            },
            // 149 — Беларусь, 159 — Казахстан
            (u.consts('client_country') == '149' || u.consts('client_country') == '159') ?
                {
                    text: iget2('b-gurantee-letter', 'realtors', 'Риэлторы'),
                    topicId: 12
                } :
                undefined,
            {
                text: iget2('b-gurantee-letter', 'obshchee', 'Общее'),
                topicId: 1
            }
        ];
    }),

    content()(function() {
        return {
            block: 'button',
            mix: [{
                block: 'b-gurantee-letter',
                elem: 'download'
            }],
            mods: { disabled: this.mods['with-choice'] === 'yes' ? 'yes' : '' },
            content: iget2('b-gurantee-letter', 'skachat', 'Скачать')
        };
    }),

    mod('with-choice', 'yes').content()(function() {
        return [
            {
                block: 'select',
                content: [
                    {
                        block: 'button',
                        mix: {
                            block: 'b-gurantee-letter',
                            elem: 'select-button'
                        }
                    },
                    {
                        elem: 'control',
                        content: [{
                            text: iget2('b-gurantee-letter', 'vyberite-shablon', 'Выберите шаблон')
                        }].concat(apply('guarantee-topics')).filter(function(option) {
                            return !!option;
                        }).map(function(option) {
                            return {
                                elem: 'option',
                                attrs: { value: option.topicId || '' },
                                content: option.text
                            };
                        })
                    }
                ]
            },
            applyNext()
        ];
    })
);
