BEM.DOM.decl('b-gurantee-letter', {

    onSetMod: {

        js: function() {
            this.select = this.findBlockInside('select');
            this.button = this.findBlockOn('download', 'button');

            this.select && this.select.on('change', this._onTopicChange, this);

            this.topicId = this.params.defaultTopicId;

            this.button.on('click', function() {
                window.location = this._getLetterUrl(this.topicId);
            }, this);
        }

    },

    /**
     * Убирает и ставит дизейбл на кнопку "Скачать" при смене значения топика
     * @private
     */
    _onTopicChange: function() {
        this.button.setMod('disabled', this.select.val() ? '' : 'yes');
        this.topicId = this.select.val();
    },

    /**
     * Возвращает ссылку на гарантийное письмо по идентификатору тематики
     * @param {Number} topicId идентификатор тематики
     * @returns {String}
     */
    _getLetterUrl: function(topicId) {
        return u.getUrl('downloadGuaranteeLetter', {
            bid: this.params.bid,
            topicid: topicId,
            agency: this.params.isAgencyEmployee ? 1 : 0
        });
    }

});
