block('b-header-skeleton')(
    content()(function() {
        var lang = /en|tr/.test(u.consts('lang')) ? 'en' : 'ru',
            isRebranding = Boolean(this.ctx.isDirectBirthdayRebrandingEnabled);

        return {
            elem: 'content',
            content: [
                isRebranding ? null : {
                    elem: 'tableau-mock',
                    attrs: {
                        style: 'width:16px;height:14px;background-image:url(\'data:image/svg+xml;charset=utf-8,%3Csvg width=\\\'16\\\' height=\\\'14\\\' xmlns=\\\'http://www.w3.org/2000/svg\\\'%3E%3Cg fill-rule=\\\'evenodd\\\'%3E%3Crect width=\\\'16\\\' height=\\\'2\\\' rx=\\\'1\\\'/%3E%3Crect y=\\\'6\\\' width=\\\'16\\\' height=\\\'2\\\' rx=\\\'1\\\'/%3E%3Crect y=\\\'12\\\' width=\\\'16\\\' height=\\\'2\\\' rx=\\\'1\\\'/%3E%3C/g%3E%3C/svg%3E\');'
                    }
                },
                {
                    elem: 'logos',
                    attrs: {
                        style: isRebranding ?
                            'padding:2px 38px 0 0;height:39px;display:flex;align-items:center' :
                            'padding:1px 38px 0 16px;height:39px;display:flex;align-items:center'
                    },
                    content: [
                        isRebranding ? {
                            block: 'link',
                            attrs: {
                                style: 'display:flex;height:32px',
                                tabindex: -1
                            },
                            url: '/',
                            title: lang === 'en' ? 'Direct' : iget2('b-header-skeleton', 'direkt', 'Директ'),
                            content: {
                                tag: 'svg',
                                attrs: {
                                    style: 'width:30px;height:30px;padding:0 6px 0 0'
                                },
                                content: {
                                    tag: 'use',
                                    attrs: {
                                        'xlink:href': '#svg-spriteDirectIcon-v2'
                                    }
                                }
                            }
                        } : {
                            block: 'link',
                            attrs: {
                                style: 'display:flex;height:32px',
                                tabindex: -1
                            },
                            url: this['i-services'].serviceUrl('www'),
                            title: lang === 'en' ? 'Yandex' : iget2('b-header-skeleton', 'yandeks', 'Яндекс'),
                            content: {
                                tag: 'svg',
                                attrs: {
                                    style: lang === 'en' ? 'width:90px;height:28px' : 'width:87px;height:28px'
                                },
                                content: {
                                    tag: 'use',
                                    attrs: {
                                        'xlink:href': '#svg-spriteYandexLogo'
                                    }
                                }
                            }
                        },
                        {
                            block: 'link',
                            attrs: {
                                style: 'display:flex;height:32px',
                                tabindex: -1
                            },
                            url: '/',
                            title: lang === 'en' ? 'Direct' : iget2('b-header-skeleton', 'direkt', 'Директ'),
                            content: {
                                tag: 'svg',
                                attrs: {
                                    style: isRebranding ?
                                        (lang === 'en' ? 'width:71px;height:30px' : 'width:91px;height:30px') :
                                        (lang === 'en' ? 'width:66px;height:28px' : 'width:85px;height:28px'),
                                },
                                content: {
                                    tag: 'use',
                                    attrs: {
                                        'xlink:href': isRebranding ? '#svg-spriteDirectLogo-v2' : '#svg-spriteDirectLogo'
                                    }
                                }
                            }
                        },
                    ]
                },
                {
                    block: 'b-header-skeleton',
                    elem: 'skeleton',
                },
                {
                    block: 'b-header-skeleton',
                    elem: 'skeleton',
                },
            ],
            attrs: {
                style: isRebranding ?
                    'display:flex;align-items:center;padding:14px 40px 15px 26px;background: #EFF2F7' :
                    'display:flex;align-items:center;padding:15px 40px 14px 16px;border-bottom:1px solid rgba(0,0,0,.06)'
            }
        }
    })
);
