BEM.DOM.decl({ block: 'b-header-title-portal-dna' }, {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            if (!dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            this._renderDna(dna);
        }
    },

    _renderDna: function(dna) {
        var dnaComp = this._getDnaComponent(dna),
            domElem = this.domElem.get(0);

        BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
            dna.reactDOMRender(dnaComp, domElem);
        });
    },

    _getDnaComponent: function(dna) {
        return dna.reactCreateElement(dna.components.HeaderTitlePortal, {
            title: this.params.title,
            hint: this.params.hint
        }, null);
    }
});
