/**
 * Блок для вывода ссылки помощи
 * @param {String} ctx.url url-адрес, который нужно загрузить для отображения
 * @param {String} [ctx.text=''] текст хэлплинка, при отсутствии будет только иконка
 * @param {String|Object} [ctx.icon='question'] значение модификатора `size-13` блока `b-icon` (строка или хэш `{ modName: modValue }`), исключение: для `notice` берется `_size-16_notice`
 * @param {Boolean} [ctx.stretched=false] флаг для растягивания контента внутри попапа (без отступов, для тех случаев, когда хэлп страница имеет свои отступы)
 * @param {Boolean} [ctx.padding=false] флаг выставляющий отступы для окна
 * @param {String} [ctx.title=''] подсказка псевдоссылки при наведении
 * @param {Number|String} [ctx.width] ширина модального попапа или нативного окна
 * @param {Number|String} [ctx.height] высота модального попапа или нативного окна
 * @param {Object} [ctx.windowParams] хэш со значениями ширины и высоты нативного окна, если нужно сделать его размеры отличными от модального попапа
 * @param {Number} [ctx.windowParams.width] ширина нативного окна
 * @param {Number} [ctx.windowParams.height] высота нативного окна
 */
block('b-help-link').replace()(function() {
    var isMobile = u.consts('isMobile'),
        isTablet = u.consts('isTablet'),
        ctx = this.ctx,
        icon = ctx.icon,
        useText = !!ctx.text,
        useIcon = !useText || !!icon,
        mods = u._.extend({}, this.mods),
        result = [],
        iconMods;

    // при одновременном использовании текста и иконки
    // проверяем позицию иконки (по умолчанию справа)
    if (useIcon && useText) {
        mods.icon || (mods.icon = 'right');
    } else {
        delete mods.icon;
    }

    // для всех мобильных устройств кроме таблетов использовать нативные модальные окна DIRECT-37873
    if (isMobile && !isTablet) delete mods.type;

    useText && result.push(ctx.text) || (mods.decoration = 'no');

    if (useIcon) {
        // DIRECT-56102 - если есть только иконка, запрещаем vertical-align: middle
        mods.align || (mods.align = useText ? (mods.icon ? 'middle' : 'baseline') : 'baseline');

        // по умолчанию, иконка "Знак вопроса"
        (!icon || icon === true) && (icon = {
            'size-13': 'question',
            theme: 'light' // серая
        });

        if (typeof icon === 'string') {
            // для alert специальный размер иконки size-12
            (iconMods = {})[icon === 'alert' ? 'size-12' : 'size-13'] = icon;
            icon === 'question' && (iconMods.theme = 'light');
        } else {
            iconMods = icon;
        }

        var iconBlock = {
            block: 'icon',
            mods: iconMods,
            mix: [{
                block: 'b-help-link',
                elem: 'icon',
                elemMods: {
                    pos: mods.icon,
                    align: mods.align,
                    size: !iconMods['size-12'] ? '' : 12
                }
            }]
        };
        if (!useText) {
            result.push({
                block: 'b-help-link',
                elem: 'inner-wrap',
                tag: 'span',
                content: iconBlock
            });
        } else {
            result.push(iconBlock);
        }
    }

    mods.icon === 'left' && result.reverse();

    return {
        block: 'b-modal-popup-opener',
        mods: {
            decoration: mods.decoration === 'no' ? '' : 'yes',
            theme: mods.theme || ''
        },
        mix: [{
            block: 'b-help-link',
            mods: {
                margin: mods.margin,
                // особый фокус для link-ов только с иконкой
                'only-icon': useText ? undefined : 'yes',
                size: icon === 'alert' ? '12' : '13'
            }
        }].concat(ctx.mix || []),
        useNativeWindow: mods.type !== 'modal',
        url: ctx.url,
        text: result,
        title: ctx.title,
        //DIRECT-58930 - @heliarian 1150 - минимальная ширина попапа, чтобы контент 980px в windows отображался без лишнего скролла
        //Если вы хотите указать ширину попапа меньше 1150px - подумайте про это еще раз
        width: ctx.width || 1150, //980(ширина b-page в центре документа) + (45 * 2)(паддинги) + 40(скроллбары)
        height: ctx.height || null,
        stretched: ctx.stretched,
        windowParams: ctx.windowParams,
        padding: ctx.padding
    };
});
