/**
 * @params {Object} modelParams параметры модели фразы, соответствующей данному блоку
 * @params {String} modelParams.name
 * @params {String} modelParams.id
 * @params {Number} treatPminAsPmax ?
 */
BEM.DOM.decl('b-highlight', {
    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOrCreate(this.params.modelParams);

            this.model.on('price', 'change', this.updatePriceView, this);

            this.campaignModel = this.model.getParentModel().getCampaignModel();

            this.updatePriceView();
        }
    },

    updatePriceView: function() {

        var brokerResponse = u.autobroker.calcPrice({
                price: this.model.get('price'),
                guarantee: this.model.get('guarantee'),
                premium: this.model.get('premium'),
                larr: this.model.get('larr'),
                minPrice: this.model.get('min_price'),
                campRest: this.campaignModel.get('sum_rest') || 0,
                dayBudget: this.campaignModel.get('day_budget'),
                spentToday: this.campaignModel.get('spent_today') || 0,
                strategy: this.campaignModel.get('strategy'),
                autobudget: this.campaignModel.get('autobudget'),
                autobudgetBid: this.campaignModel.get('autobudget_bid'),
                timetargetingCoef: this.campaignModel.get('timetarget_coef'),
                currency: this.campaignModel.get('currency'),
                onlyFirstGuarantee: this.campaignModel.get('mediaType') == 'mcbanner'
            }),
            PLACE_NAMES = u._.invert(u.consts('PRICE_PLACES')),
            ENTRY_PLACES = u.consts('ENTRY_PLACES'),
            typeMap = {
                GUARANTEE1: 'max',
                PREMIUM1: 'pmax',
                PREMIUM2: 'pmax2',
            },
            placeName;

        typeMap[PLACE_NAMES[ENTRY_PLACES.PREMIUM]] = 'pmin';
        typeMap[PLACE_NAMES[ENTRY_PLACES.GUARANTEE]] = 'min';

        this.delMod(this.elem('num'), 'hilited');

        placeName = PLACE_NAMES[brokerResponse.placeName];

        if (typeMap[placeName]) {

            //todo@kabzon DIRECT-46225
            !this.params.showSecondPosition && placeName === 'PREMIUM2' &&
                (placeName = PLACE_NAMES[ENTRY_PLACES.PREMIUM]);

            this.setMod(this.elem('num', 'name', typeMap[placeName]), 'hilited', 'yes');
        }
    }
}, {
    live: true
});
