BEM.DOM.decl('b-hintable-popup', {
    onSetMod: {
        js: function() {
            this._hint = this.params.hint || '';

            this.bindTo(this.domElem, 'click', this._toggleHint.bind(this))
        }
    },

    /**
     * Устанавливает новый текст подсказки
     * @param {String|HTML|jQuery } content - текст подсказки или DOM элемент
     */
    setHintContent: function(content) {
        this._hint = content;
        this._updateHintContent();
    },

    /**
     * Прячет хинт
     * @private
     */
    hideHint: function() {
        this._hideHint();
    },

    /**
     * Обновляет содержимое попапа подсказки
     */
    _updateHintContent: function() {
        this._getHintPopup().setContent(BEMHTML.apply(this._hint));
    },

    /**
     * Меняет видимость подсказки
     */
    _toggleHint: function(e) {
        this._getHintPopup().isShown() ?
            this._hideHint() :
            this._showHint();

        e.stopPropagation();
    },

    /**
     * Показывает предупреждающий хинт, если задан не пустой текст для него
     * @private
     */
    _showHint: function() {
        if (!this._hint) { return; }

        this._updateHintContent();

        this._getHintPopup().show(this.domElem);
    },

    /**
     * Прячет хинт
     * @private
     */
    _hideHint: function() {
        this._getHintPopup().hide();
    },

    /**
     * Возвращает блок попап для показа подсказки
     * @returns {BEM}
     */
    _getHintPopup: function() {
        this.popup ||
            (this.popup = $(BEMHTML.apply({
                block: 'popup',
                js: { directions: this.params.directions || ['right', 'left', 'bottom', 'top'] },
                mods: {
                    'has-close': 'yes',
                    'on-scroll': this.params.onScroll || ''
                },
                mix: this.params.mixPopup || {},
                content: [
                    { elem: 'tail' },
                    { elem: 'content' }
                ]
            })).appendTo(document.body).bem('popup'));

        return this.popup;
    },

    /**
     * Уничтожает блок
     * @returns {BEM.DOM}
     */
    destruct: function() {
        this.popup && this.popup.destruct();
        this.__base();
    }
});
