block('b-href-control')(
    def()(function() {
        var HTTPS = 'https://',
            protocol = this.ctx.protocol || HTTPS;

        return applyNext({
            'mods.protocol-warning': this.ctx.forceHttps && protocol !== HTTPS ? 'yes' : ''
        });
    }),

    js()(function() {
        return {
            limit: this.ctx.limit || u.consts('MAX_URL_LENGTH'),
            forceHttps: !!this.ctx.forceHttps
        };
    }),

    content()(function() {
        var HTTP = 'http://',
            HTTPS = 'https://',
            maxLength = this.ctx.limit || u.consts('MAX_URL_LENGTH'),
            protocol = this.ctx.protocol || HTTPS,
            protocols = [HTTPS, HTTP];

        return [
            {
                elem: 'controls',
                content: [
                    {
                        block: 'select',
                        mix: {
                            block: 'b-href-control',
                            elem: 'protocol'
                        },
                        mods: {
                            disabled: this.ctx.protocolReadOnly ? 'yes' : ''
                        },
                        content: [
                            {
                                block: 'button',
                                content: protocol
                            }, {
                                elem: 'control',
                                content: protocols.map(function(value) {
                                    return {
                                        elem: 'option',
                                        attrs: {
                                            value: value,
                                            selected: value === protocol || undefined
                                        },
                                        content: value
                                    };
                                })
                            }
                        ]
                    },
                    {
                        block: 'input',
                        mods: {
                            counter: 'yes',
                            disabled: this.ctx.hrefReadOnly ? 'yes' : ''
                        },
                        mix: {
                            block: 'b-href-control',
                            elem: 'href'
                        },
                        value: this.ctx.href,
                        limit: maxLength - protocol.length,
                        content: [{ elem: 'control' }]
                    }
                ]
            },
            {
                elem: 'hint'
            },
            {
                elem: 'protocol-hint',
                content: {
                    block: 'icon-text',
                    mods: {
                        theme: 'info',
                        size: 'xs'
                    },
                    text: [
                        iget2('b-href-control', 'https-hint', 'Лучше перевести сайт на HTTPS.'),
                        ' ',
                        {
                            block: 'link',
                            url: u.getCommonHelpUrl('/webmaster/yandex-indexing/https-migration.html'),
                            attrs: {
                                target: '_blank'
                            },
                            content: iget2('b-href-control', 'https-hint-details', 'Подробнее'),
                        }
                    ]
                }
            }
        ]
    })
);
