block('b-href-params')(

    def()(function() {
        var value = String(this.ctx.value || ''),
            maxLength = this.ctx.maxLength;

        // если задана максимальная длина, устанавливаем модификатор `error`
        value && maxLength && value.length > maxLength && (this.mods.error = 'yes');

        return applyNext();
    }),

    js()(function() {
        return {
            maxLength: this.ctx.maxLength
        };
    }),

    content()(function() {
        var value = this.ctx.value,
            maxLength = this.ctx.maxLength;

        return [
            {
                elem: 'header',
                content: iget2('b-href-params', 'header', 'Трекинговые параметры')
            },
            {
                elem: 'controls-add',
                content: [
                    {
                        block: 'button2',
                        mix: { block: 'b-href-params', elem: 'add' },
                        mods: {
                            size: 's',
                            theme: 'link-black'
                        },
                        content: [
                            {
                                block: 'icon',
                                mix: [
                                    { block: 'b-href-params', elem: 'add-icon', elemMods: { hovered: 'no' } }
                                ],
                                mods: {
                                    type: 'add'
                                }
                            },
                            {
                                block: 'icon',
                                mix: [
                                    { block: 'b-href-params', elem: 'add-icon', elemMods: { hovered: 'yes' } }
                                ],
                                mods: {
                                    type: 'add-red'
                                }
                            },
                            iget2('b-href-params', 'btn-add-params2', 'Добавить трекинговые параметры')
                        ]
                    }
                ]
            },
            {
                elem: 'controls-edit',
                content: [
                    {
                        block: 'input',
                        mix: { block: 'b-href-params', elem: 'input' },
                        content: { elem: 'control' },
                        value: value
                    },
                    {
                        block: 'button',
                        mix: { block: 'b-href-params', elem: 'cancel' },
                        mods: { pseudo: 'yes' },
                        content: iget2('b-href-params', 'btn-delete', 'Удалить')
                    }
                ]
            },
            {
                elem: 'error-message',
                maxLength: maxLength
            },
            {
                elem: 'disclaimer',
                content: iget2('b-href-params', 'disclaimer', 'Параметры будут добавлены ко всем ссылкам в этом объявлении на Турбо-страницы, в том числе и в быстрых ссылках. Зачем нужны {tracking-params-help-link}', {
                    'tracking-params-help-link': {
                        block: 'link',
                        url: u.getCommonHelpUrl('/direct-tooltips/turbo-pages-url-tags.html'),
                        target: '_blank',
                        content: iget2('b-href-params', 'tracking-params-help-link', 'трекинговые параметры')
                    }
                })
            }
        ]
    }),

    elem('error-message').content()(function() {
        return u.pluralForms(
            iget2(
                'b-href-params',
                'error-message-max-length',
                'Превышена максимальная длина строки параметров ссылки, {maxLength} {символ|символа|символов}.',
                { maxLength: this.ctx.maxLength }
            ),
            this.ctx.maxLength
        )
    })

);
