BEM.DOM.decl('b-href-params', {

    onSetMod: {
        js: function() {

            // elems
            this._input = this.findBlockOn('input', 'input');
            this._btnAdd = this.findBlockOn('add', 'button2');
            this._btnCancel = this.findBlockOn('cancel', 'button');

            // events
            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.wrap(this._input).on('change', function() {
                this._updateValue();
            }, this);

            this._subscribe.wrap(this._btnAdd).on('click', function() {
                this.setMod('active', 'yes');
            }, this);

            this._subscribe.wrap(this._btnCancel).on('click', function() {
                this.delMod('active');
            }, this);

            // value
            this._updateValue();
        },

        active: function() {
            this.afterCurrentEvent(this._updateValue.bind(this));
        },

        disabled: function(modName, modVal) {
            this._input.setMod(modName, modVal);
            this._btnAdd.setMod(modName, modVal);
            this._btnCancel.setMod(modName, modVal);
        }
    },

    /**
     * Получить текущее значение
     * @returns {String}
     */
    getValue: function() {
        return this._value;
    },

    /**
     * Установить значнеие в поле ввода
     * @param {String} newValue
     */
    setInputValue: function(newValue) {

        if (!!newValue || this.hasMod('active')) {
            this._input.val(newValue);
        }
    },

    _updateValue: function() {
        var newValue = this.hasMod('active') && !this.hasMod('disabled') ? this._input.val() : '',
            maxLength = this.params.maxLength;

        if (this._value !== newValue) {
            this._value = newValue;

            if (maxLength) {
                newValue.length > maxLength ?
                    this._showErrors() :
                    this._clearErrors();
            }

            this.trigger('change', newValue);
        }
    },

    _showErrors: function() {
        this.setMod('error', 'yes');
    },

    _clearErrors: function() {
        this.delMod('error');
    },

    /**
     * Удаляет блок и подписки на события
     */
    destruct: function() {
        this._subscribe.dispose();

        return this.__base.apply(this, arguments);
    }
});
