# b-href-params

Блок для ввода параметров ссылки.

## Контекст блока

### Поле `help`

Задает ID справочной ссылки (формируется при помощи `u.getHelpUrl(helpId)`)

### Поле `value`

Задает значение в поле ввода.

### Модификатор `active`

- без модификатора - блок в неактивном состоянии - выглядит как кнопка "Добавить параметры ссылки". При нажатии на кнопку блок переходит в активное состояние.
- `active_yes` - блок активном состоянии - выглядит как поле ввода параметров и кнопка "Отменить" (переводит блок в неактивное состояние).

### Пример

```
{
    block: 'b-href-params',
    mods: {
        active: 'yes'
    },
    help: 'my-help-id',
    btnText: 'My button text',
    value: 'a=1&b=2&c=3'
}
```

## API

### `getValue`

Получить текущее значение блока. Значение блока в активном состоянии равно значению в поле ввода. Значение в реактивном состоянии - пустая строка.

### `setInputValue(newValue)`

Установить значнеие в поле ввода.

### Событие `'change'`

Генерируется при изменении значения блока:
- при изменении состояния блока (активное/неактивное)
- при изменении значения в поле ввода в активном состоянии
