block('b-href-popup')(
    elem('label').content()(function() {
        return iget2('b-href-popup', 'ssylka-na-sayt', 'Ссылка на сайт');
    }),

    elem('hint').content()(function() {
        return [
            { elem: 'line', content: iget2('b-href-popup', 'dobavlenie-ssylki-dlya-vseh', 'Добавление ссылки для всех создаваемых объявлений.') },
            { elem: 'line', content: iget2('b-href-popup', 'v-dalneyshem-vy-vsegda', 'В дальнейшем вы всегда сможете изменить её.') }
        ];
    }),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'panel',
                content: { elem: 'hint' }
            },
            {
                elem: 'panel',
                content: [
                    { elem: 'label' },
                    {
                        block: 'b-href-control',
                        mix: { block: 'b-href-popup', elem: 'href' },
                        href: ctx.href || '',
                        protocol: ctx.protocol || ''
                    }
                ]
            },
            {
                elem: 'actions',
                content: [
                    {
                        block: 'button',
                        mods: { theme: 'action' },
                        mix: { block: 'b-href-popup', elem: 'save' },
                        content: ctx.btnOkText || iget2('b-href-popup', 'ok', 'Ок')
                    },
                    {
                        block: 'button',
                        mix: { block: 'b-href-popup', elem: 'cancel' },
                        content: ctx.btnCancelText || iget2('b-href-popup', 'otmena', 'Отмена')
                    }
                ]
            }
        ];
    })
);
