BEM.DOM.decl({ block: 'b-href-popup', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {

            this._href = this.findBlockOn('href', 'b-href-control');
            this._btnSave = this.findBlockOn('save', 'button');
            this._btnCancel = this.findBlockOn('cancel', 'button');

            this._subscribe = BEM.create('i-subscription-manager');

            this._subscribe.wrap(this._href).on('state:changed', this._updateButtonState, this);
            this._subscribe.wrap(this._btnSave).on('click', this._save, this);
            this._subscribe.wrap(this._btnCancel).on('click', this._cancel, this);
        }
    },

    /**
     * Реализация интерфейса i-modal-popup-inner-block-interface
     * @returns {*}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(false);

        return deferred;
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subscribe.dispose();
        this.__base.apply(this, arguments);
    },

    /**
     * Обновляет состояние кнопки "Применить" при изменении статуса валидации ссылки
     * @param {Object} e - параметры события
     * @param {Object} data - информация о статусе проверки ссылки
     * @private
     */
    _updateButtonState: function(e, data) {
        this._btnSave.setMod('disabled', data.isReady ? '' : 'yes');
    },

    /**
     * Оповещает родительский блок о том, что нужно применить указанное значение ссылки
     * @private
     */
    _save: function() {
        this.trigger('save', this._href.val());
    },

    /**
     * Оповещает родительский блок, что пользователь нажал кнопку "Отмена"
     * @private
     */
    _cancel: function() {
        this.trigger('cancel');
    }
}, {
    /**
     * Открывает окно ввода общей ссылки
     * @param {Function} cb - callback при закрытии попапа
     * @param {*} ctx - контекст выбора для cb
     * @param {Object} options - дополнительные параметры
     * @param {Boolean} [options.isMobileCampaign] - ссылка предназначена для РМП кампании (отображается другой заголовок)
     * @param {String} [options.btnOkText] - текст на кнопке "Ок"
     * @param {String} [options.btnCancelText] - текст на кнопке "Отмена"
     * @param {String} [options.href] - ссылка
     * @returns {*}
     */
    create: function(cb, ctx, options) {
        var selectedHref,
            opts = options || {},
            modal = BEM.DOM.blocks['b-modal-popup-decorator'].create2(undefined, { bodyScroll: false }, $),
            content = modal.setPopupContent({
                block: 'b-href-popup',
                mods: { type: opts.isMobileCampaign ? 'mobile' : '' },
                btnOkText: opts.btnOkText,
                btnCancelText: opts.btnCancelText,
                href: opts.href,
                protocol: opts.protocol
            });

        content.on('save cancel', function(e, href) {
            selectedHref = href;
            modal.hide();
        });

        modal.on('close', function() {
            cb.call(ctx || content, selectedHref);
        });

        return modal;
    }
});
