(function() {

    /**
     * Обрабатывает событие скролла переданного блока
     * @param {jQuery} options.owner родительский контейнер, скролл которого слушаем
     * @param {Object} options.onScroll обработчик скролла для дочернего блока
     * @constructor
     */
    function ScrollListener(options) {
        this.owner = options.owner;
        this._children = [];
        this._onScroll = options.onScroll;
        this._scrollHandler = this._scrollHandler.bind(this);

        this.owner.on('scroll', this._scrollHandler);
    }

    $.extend(ScrollListener.prototype, {

        /**
         * Добавляет блок в массива блоков реагирующих на скролл родителя
         * @param {Object} childBlock i-bem блок
         */
        add: function(childBlock) {
            this._children.push(childBlock);
        },

        /**
         * Удаляет блок из массива блоков реагирующих на скролл родителя
         * @param {Object} childBlock i-bem блок
         */
        remove: function(childBlock) {
            this._children = this._children.filter(function(listChildBlock) {
                return listChildBlock !== childBlock
            });
        },

        /**
         * Проверяет есть ли дочерние блоки
         * @returns {boolean}
         */
        hasChildren: function() {
            return !!this._children.length;
        },

        /**
         * Деструктор
         */
        destruct: function() {
            this.owner.off('scroll', this._scrollHandler);
        },

        /**
         * Обработчик скролла родительского блока
         * @private
         */
        _scrollHandler: function() {
            this._children.forEach(function(childBlock) {
                this._onScroll(childBlock);
            }, this);
        }
    });

    BEM.DOM.decl({ block: 'b-icon-hint' }, {

        onSetMod: {
            js: function() {
                this._tooltip = this.findBlockInside('tooltip');
                this._icon = this.findElem('icon');

                this._tooltip
                    .setOwner(this._icon)
                    .on(
                        'show', function() {
                            this._tooltipOpened = true;
                        }, this)
                    .on(
                        'hide', function() {
                            this._tooltipOpened = false;
                        }, this);
            }
        },

        /**
         * Закрывает тултип
         */
        closeTooltip: function() {
            this._tooltipOpened && this._tooltip.delMod('shown');
        },

        /**
         * Устанавливает контейнер скролл которого слушаем для закрытия тултипа
         * @param {jQuery|BEM} scrollOwner Блок или элемент
         */
        setScrollOwner: function(scrollOwner) {
            this.__self.listenScroll(scrollOwner.domElem || scrollOwner, this);
        },

        destruct: function() {
            this.__self.unlistenScroll(this);
            this.__base.apply(this, arguments);
        },

        /**
         * Обработчик клика по иконке
         * @private
         */
        _onClick: function() {
            this._tooltip.setMod('shown', 'yes');
        }

    }, {

        live: function() {
            this.liveBindTo(
                'icon', 'click', function(e) {
                    this._onClick(e);
                });
        },

        /**
         * Массив объектов для обработки скролла
         */
        _scrollListeners: [],

        /**
         * Инициализирует блок b-icon-hint для прослушивания скролла контейнера owner
         * @param {jQuery|BEM} owner контейнер, скролл которого слушаем
         * @param {BEM} iconHint блок b-icon-hint
         */
        listenScroll: function(owner, iconHint) {
            var scrollListener = u._.find(this._scrollListeners, function(scrollListener) {
                return owner.is(scrollListener.owner);
            });

            if (!scrollListener) {
                scrollListener = new ScrollListener({
                    owner: owner,
                    onScroll: function(iconHint) {
                        iconHint.closeTooltip();
                    }
                });
                this._scrollListeners.push(scrollListener);
            }

            scrollListener.add(iconHint);
        },

        /**
         * Убираем блок b-icon-hint из списка прослушивающих блоков скролл
         * @param {Object} iconHint блок b-icon-hint
         */
        unlistenScroll: function(iconHint) {
            this._scrollListeners = this._scrollListeners.filter(function(scrollListener) {
                scrollListener.remove(iconHint);
                // если больше нет дочерних блоков, то удаляем scrollListener
                if (!scrollListener.hasChildren()) {
                    scrollListener.destruct();
                    return false;
                }

                return true;
            });
        }

    });
})();
