BEM.DOM.decl('b-iframe-modal', {
    onSetMod: {
        js: function() {
            this._closeBtn = this.findBlockOn('close-modal-button', 'button2');
            this._iframe = this.findBlockOn('iframe', 'b-iframe');
            this._title = this.elem('title');

            this._closeBtn.on('click', this._onClose, this);
        }
    },

    destruct: function() {
        this._closeBtn.un('click', this._onClose, this);

        return this.__base.apply(this, arguments);
    },

    /**
     * Возврящает шину событий, инициируемых на загружаемых страницах
     * @return {BEM.DOM}
     */
    getEventBus: function() {
        return this._iframe.getEventBus();
    },

    setTitle: function(title) {
        this._title.text(title);
        this.setMod(this._title, 'hidden', title ? 'no' : 'yes');
        return this;
    },

    _onClose: function() {
        this.destruct()
    },

    setSrc: function(src) {
        this._iframe.domElem[0].setAttribute('src', src);
        return this;
    }
});
