/**
 * @param {Object} ctx.gallery массив ранее загруженных изображений
 * @param {String} ctx.gallery.name имя файла
 * @param {String} ctx.gallery.url ссылка на файл
 * @param {Number} ctx.gallery.width ширина изображения
 * @param {Number} ctx.gallery.height высота изображения
 * @param {String} ctx.buttonText текст кнопки селектора
**/
block('b-image-ad-selector')(
    js()(true),

    content()(function() {
        var ctx = this.ctx;

        return [
            {
                elem: 'pane',
                content: [
                    {
                        block: 'b-image-add-loader',
                        mods: {
                            view: 'compact'
                        },
                        mix: {
                            block: 'b-image-ad-selector',
                            elem: 'loader'
                        },
                        buttonText: ctx.buttonText,
                        gallery: ctx.gallery,

                        mediaType: ctx.mediaType,
                        clientId: ctx.clientId,

                        isNewBanner: true,

                        singleImageUpload: ctx.singleImageUpload,
                        askGroupLink: false
                    },
                    {
                        elem: 'hint',
                        data: {
                            mediaType: ctx.mediaType
                        }
                    }
                ]
            },
            { elem: 'preview' }
        ];
    })
);
