(function() {

    u.register({
        'b-image-ad-selector': {

            /**
             * Формирует текст заголовка панели выбора изображений
             * @param {String} [mediaType]
             * @param {Number} [changedCount] - количество изменяемых изображений
             * @returns {String}
             */
            getTitle: function(mediaType, changedCount) {

                if (!changedCount) return '';

                if (mediaType === 'mcbanner') {
                    return iget2(
                        'b-image-ad-selector',
                        'title-for-mcb-creative',
                        'Креатив будет изменен в {foo} баннере',
                        {
                            foo: changedCount,
                            count: changedCount,
                            many: 'Креатив будет изменен в {foo} баннерах',
                            some: 'Креатив будет изменен в {foo} баннерах',
                            none: 'Нет подходящих баннеров для замены'
                        }
                    );
                }

                return iget2(
                    'b-image-ad-selector',
                    'title-for-creative',
                    'Креатив будет изменен в {foo}&nbsp;объявлении',
                    {
                        foo: changedCount,
                        count: changedCount,
                        many: 'Креатив будет изменен в {foo} объявлениях',
                        some: 'Креатив будет изменен в {foo} объявлениях',
                        none: 'Нет подходящих объявлений для замены'
                    }
                );
            }
        }
    });

})();
