/**
 * @param {Object} ctx.image информация о загруженном файле
 * @param {String} ctx.image.name имя файла
 * @param {String} ctx.image.hash ссылка на файл
 * @param {String} ctx.image.width ширина изображения
 * @param {String} ctx.image.height высота изображения
 * @param {Object} ctx.gallery массив ранее загруженных изображений
 * @param {String} ctx.gallery.name имя файла
 * @param {String} ctx.gallery.url ссылка на файл
 * @param {Number} ctx.gallery.width ширина изображения
 * @param {Number} ctx.gallery.height высота изображения
 * @param {String} ctx.buttonText текст кнопки селектора
**/
block('b-image-add-loader')(
    def()(function() {
        var ctx = this.ctx;

        return applyNext({
            'ctx.singleImageUpload': ctx.singleImageUpload || !ctx.isNewBanner,

            'ctx.isCPM': u.campaign.isCpm(ctx.mediaType),
            'ctx.isMcbanner': ctx.mediaType === 'mcbanner',
            'ctx.isMobileCampaign': ctx.mediaType === 'mobile_content'
        });
    }),

    js()(function() {
        var ctx = this.ctx,
            utils = u['b-image-add-loader'];

        return {
            modelName: 'b-image-add-loader',
            modelData: {
                image: utils.isEmptyImage(ctx.image) ? undefined : ctx.image,
                creative: utils.isEmptyCreative(ctx.creative) ? undefined : ctx.creative,
            },
            availableBannerCount: ctx.availableBannerCount,
            askGroupLink: !!ctx.askGroupLink,
            gallery: ctx.gallery || [],

            isNewBanner: ctx.isNewBanner,
            isMobileCampaign: ctx.isMobileCampaign,
            isMcbanner: ctx.isMcbanner,
            isCPM: ctx.isCPM,

            bannerId: ctx.bannerId,
            clientId: ctx.clientId,
            dmParams: ctx.dmParams,

            mediaType: ctx.mediaType
        }
    }),

    content()(function() {
        var ctx = this.ctx,
            utils = u['b-image-add-loader'],
            isImageLoaded = !utils.isEmptyImage(ctx.image) || !utils.isEmptyCreative(ctx.creative),
            access = utils.getAvailableItems(ctx.mediaType),
            button = {
                block: 'button2',
                mods: {
                    size: 's',
                    theme: 'normal',
                    view: 'classic',
                    tone: 'default'
                },
                mix: [
                    { block: this.block, elem: 'switcher-button' },
                    { block: 'dropdown', elem: 'switcher' }
                ],
                content: [
                    {
                        elem: 'icon',
                        elemMods: { side: 'right' },
                        icon: {
                            mods: {
                                size: 's',
                                type: 'arrow',
                                direction: 'bottom'
                            }
                        }
                    },
                    {
                        elem: 'text',
                        content: this.ctx.buttonText || {
                            block: this.block,
                            elem: 'model-field',
                            js: {
                                name: 'buttonText',
                                type: 'inline'
                            },
                            content: isImageLoaded ?
                                iget2('b-image-add-loader', 'izmenit', 'Изменить') :
                                iget2('b-image-add-loader', 'dobavit', 'Добавить')
                        }
                    }
                ]
            };

        if (utils.is728FrontpageCreative(ctx.mediaType, ctx.creative)) {

            button.mods.disabled = 'yes';
            button = {
                block: this.block,
                elem: 'tooltip-hover',
                js: {
                    'tooltip-content': iget2(
                        'b-image-add-loader',
                        'creative-cannot-be-changed',
                        'Заменить креатив невозможно, так как креативы размером 728×90 больше не поддерживаются. Создайте новое объявление с креативом 1456×180.'
                    )
                },
                content: button
            };
        }

        return [
            {
                block: 'dropdown',
                mods: { 'no-tail': 'yes' },
                mix: {
                    block: this.block,
                    elem: 'select'
                },
                content: [
                    button,
                    {
                        elem: 'popup',
                        mods: {
                            adaptive: 'yes'
                        },
                        mix: { block: 'b-image-add-loader', elem: 'popup' },
                        js: { directions: ['bottom-left', 'right'] },
                        content: [
                            {
                                block: 'b-image-add-loader',
                                elem: 'chooser',
                                content: u._.compact([
                                    access.creativesAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'creatives' },
                                            content: [
                                                iget2('b-image-add-loader', 'konstruktor-kreativov', 'Конструктор креативов'),
                                                {
                                                    elem: 'help-link',
                                                    isCPM: ctx.isCPM
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'constructor-create', position: 'creatives' },
                                            content: iget2('b-image-add-loader', 'sozdat-novye-po-shablonu', 'Создать новые по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'constructor-create-adaptive-image-ad', position: 'creatives' },
                                            content: iget2('b-image-add-loader', 'adaptive-image-ad', 'Адаптивные графические объявления')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'constructor-ideas', position: 'creatives' },
                                            content: iget2('b-image-add-loader', 'idei-dlya-kreativov', 'Идеи для креативов')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'constructor-select', position: 'creatives' },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-sozdannih', 'Выбрать из ранее созданных')
                                        }
                                    ],
                                    access.html5CreativesAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'creatives' },
                                            content: [
                                                iget2('b-image-add-loader', 'gotovye-kreativy', 'Готовые креативы'),
                                                {
                                                    elem: 'help-link',
                                                    isFrontpage: ctx.mediaType === 'cpm_yndx_frontpage',
                                                    isCPM: ctx.isCPM
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'constructor-html5-add', position: 'creatives' },
                                            content: iget2('b-image-add-loader', 'cpmbanner-download', 'Загрузить креативы')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'constructor-html5-choose-from-uploaded',
                                                position: 'creatives'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-zagruzhennyh', 'Выбрать из ранее загруженных')
                                        }
                                    ],
                                    access.loadingImageAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'images' },
                                            content: [
                                                iget2('b-image-add-loader', 'gotovye-kreativy', 'Готовые креативы'),
                                                {
                                                    elem: 'help-link',
                                                    isMcbanner: ctx.isMcbanner
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: ctx.singleImageUpload ? 'local' : 'local-multiple',
                                                position: 'images'
                                            },
                                            content: iget2('b-image-add-loader', 'zagruzit-s-kompyutera', 'Загрузить с компьютера')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'external', position: 'images' },
                                            content: iget2('b-image-add-loader', 'zagruzit-po-ssylke', 'Загрузить по ссылке')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'gallery',
                                                disabled: ctx.gallery && ctx.gallery.length ? '' : 'yes',
                                                position: 'images'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-zagruzhennyh', 'Выбрать из ранее загруженных')
                                        }
                                    ],
                                    access.cpmVideoAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'video' },
                                            content: [
                                                iget2('b-image-add-loader', 'video-kreativ', 'Видео креатив'),
                                                {
                                                    elem: 'help-link',
                                                    url: u.getHelpUrl('cpm-campaign-video-creative-requirements')
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'video-addition-create', position: 'video' },
                                            content: iget2('b-image-add-loader', 'skonstryirovat-po-hablony', 'Сконструировать по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'video-addition-gallery',
                                                position: 'video'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-dobavlennih', 'Выбрать из ранее добавленных')
                                        }
                                    ],
                                    access.cpmAudioAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'audio' },
                                            content: [
                                                iget2('b-image-add-loader', 'audio-kreativ', 'Аудиокреатив'),
                                                {
                                                    elem: 'help-link',
                                                    url: u.getHelpUrl('cpm-campaign-audio-creative-requirements')
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'audio-addition-create', position: 'audio' },
                                            content: iget2('b-image-add-loader', 'skonstryirovat-po-hablony', 'Сконструировать по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'audio-addition-gallery',
                                                position: 'audio'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-dobavlennih', 'Выбрать из ранее добавленных')
                                        }
                                    ],
                                    access.cpmOutdoorAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'outdoor-video' },
                                            content: [
                                                iget2('b-image-add-loader', 'video-kreativ', 'Видео креатив'),
                                                {
                                                    elem: 'help-link',
                                                    url: u.getHelpUrl('cpm-campaign-video-creative-requirements')
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'video-outdoor-create', position: 'outdoor-video' },
                                            content: iget2('b-image-add-loader', 'skonstryirovat-po-hablony', 'Сконструировать по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'video-outdoor-gallery',
                                                position: 'outdoor-video'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-dobavlennih', 'Выбрать из ранее добавленных')
                                        }
                                    ],
                                    access.cpmIndoorAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'indoor-video' },
                                            content: [
                                                iget2('b-image-add-loader', 'video-kreativ', 'Видео креатив'),
                                                {
                                                    elem: 'help-link',
                                                    url: u.getHelpUrl('cpm-campaign-video-creative-requirements')
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'video-indoor-create', position: 'indoor-video' },
                                            content: iget2('b-image-add-loader', 'skonstryirovat-po-hablony', 'Сконструировать по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'video-indoor-gallery',
                                                position: 'indoor-video'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-dobavlennih', 'Выбрать из ранее добавленных')
                                        }
                                    ],
                                    access.cpcVideoAllowed && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'cpc-video' },
                                            content: [
                                                iget2('b-image-add-loader', 'video-kreativ', 'Видео креатив'),
                                                {
                                                    elem: 'help-link',
                                                    url: u.getHelpUrl('video-ads-rules')
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                visibility: 'hidden',
                                                type: ctx.isMobileCampaign ? 'mobile-content-video-create' : 'cpc-video-create',
                                                position: 'cpc-video'
                                            },
                                            content: iget2('b-image-add-loader', 'skonstryirovat-po-hablony', 'Сконструировать по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                visibility: 'hidden',
                                                type: ctx.isMobileCampaign ? 'mobile-content-video-creatives' : 'cpc-video-gallery',
                                                position: 'cpc-video'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-dobavlennih', 'Выбрать из ранее добавленных')
                                        }
                                    ],
                                    access.cpmGeoProduct && [
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'geoproduct' },
                                            content: [
                                                iget2('b-image-add-loader', 'konstruktor-kreativov-metro', 'Конструктор креатива для Яндекс.Метро'),
                                                {
                                                    elem: 'help-link',
                                                    isCPM: ctx.isCPM
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'cpm-geoproduct-canvas-create', position: 'geoproduct' },
                                            content: iget2('b-image-add-loader', 'sozdat-novye-po-shablonu', 'Создать новые по шаблону')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'cpm-geoproduct-canvas-select', position: 'geoproduct' },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-sozdannih', 'Выбрать из ранее созданных')
                                        },
                                        {
                                            elem: 'chooser-group-title',
                                            elemMods: { visibility: 'visible', position: 'geoproduct' },
                                            content: [
                                                iget2('b-image-add-loader', 'gotovye-kreativy-metro', 'Готовые креативы для Яндекс.Метро'),
                                                {
                                                    elem: 'help-link',
                                                    isCPM: ctx.isCPM
                                                }
                                            ]
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: { type: 'cpm-geoproduct-html5-add', position: 'geoproduct' },
                                            content: iget2('b-image-add-loader', 'cpmbanner-download', 'Загрузить креативы')
                                        },
                                        {
                                            elem: 'chooser-item',
                                            elemMods: {
                                                type: 'cpm-geoproduct-html5-choose-from-uploaded',
                                                position: 'geoproduct'
                                            },
                                            content: iget2('b-image-add-loader', 'vybrat-iz-ranee-zagruzhennyh', 'Выбрать из ранее загруженных')
                                        }
                                    ],
                                ])
                            }
                        ]
                    }
                ]
            },
            {
                block: 'spin2',
                mods: { size: 'xs' },
                mix: {
                    block: this.block,
                    elem: 'spin'
                }
            },
            {
                elem: 'sign',
                elemMods: {
                    visible: isImageLoaded ? 'yes' : ''
                },
                mix: [
                    {
                        elem: 'model-field',
                        js: {
                            name: 'isImageLoaded',
                            block: 'b-image-add-loader',
                            elem: 'sign',
                            modName: 'visible',
                            type: 'mod'
                        }
                    }
                ],
                content: {
                    elem: 'model-field',
                    mix: {
                        block: 'b-image-add-loader',
                        elem: 'sign-content'
                    },
                    js: {
                        name: 'name',
                        type: 'inline'
                    },
                    content: u.escapeHTML(u['b-image-add-loader'].getName(ctx.image, ctx.creative))
                }
            }
        ];
    }),

    /**
     * @param {Boolean} [ctx.isMcbanner]
     * @param {Boolean} [ctx.isCPM]
     */
    elem('help-link')(
        replace()(function() {
            var ctx = this.ctx,
                url;

            if (ctx.isMcbanner) {
                url = u.getHelpUrl('media-context-banner-rules');
            } else if (ctx.isFrontpage) {
                url = u.getHelpUrl('cpm-campaign-frontpage-creative-requirements');
            } else if (ctx.isCPM) {
                url = u.getHelpUrl('cpm-campaign-creative-requirements');
            } else {
                url = u.getHelpUrl('image-ads-rules')
            }

            return {
                block: 'b-help-link',
                mods: { type: 'modal' },
                mix: {
                    block: 'b-image-add-loader',
                    elem: 'help-link'
                },
                stretched: true,
                icon: 'question',
                url: ctx.url || url
            };
        })
    )
);
