u.register({
    'b-image-add-loader': {

        /**
         * Проверяет, является ли изображение пустым
         * @param {Object} image - проверяемое изображение
         * @returns {Boolean}
         */
        isEmptyImage: function(image) {
            return !image || !image.hash;
        },

        /**
         * Проверяет, является ли креатив пустым
         * @param {Object} creative - проверяемое изображение
         * @returns {Boolean}
         */
        isEmptyCreative: function(creative) {
            return !creative || !creative.creative_id;
        },

        is728FrontpageCreative: function(mediaType, creative) {
            return mediaType === 'cpm_yndx_frontpage' && !!creative && creative.width == 728 && creative.height == 90;
        },

        isVideoCreative: function(creative) {
            return creative.creative_type === 'video_addition';
        },

        /**
         * Получает название изображения/креатива для отображения
         * @param {Object} image
         * @param {Object} creative
         * @returns {String}
         */
        getName: function(image, creative) {
            return this.isEmptyImage(image) ?
                this.isEmptyCreative(creative) ? '&mdash;' : creative.name :
                image.name;
        },

        /**
         * Возвращает отображаемый набор типов выбора креативов
         * @param {Object} data
         * @param {Object} data.image
         * @param {Object} data.creative
         * @param {String} data.mediaType
         * @param {Boolean} data.isNewBanner
         * @param {Boolean} [data.adType]
         * @param {String} [data.cpmGroupType]
         * @returns {Object}
         */
        getActiveItems: function(data) {
            var current,
                access;

            if (!data.isNewBanner) {

                if (!this.isEmptyImage(data.image)) {
                    current = 'images';
                } else if (!this.isEmptyCreative(data.creative)) {
                    if (data.cpmGroupType === 'cpm_geoproduct') {
                        return ['geoproduct'];
                    }

                    if (this.isVideoCreative(data.creative)) {
                        if (data.cpmGroupType === 'cpm_outdoor') {
                            return ['outdoor-video'];
                        }

                        if (data.cpmGroupType === 'cpm_indoor') {
                            return ['indoor-video'];
                        }

                        if (data.cpmGroupType === 'cpm_audio') {
                            return ['audio'];
                        }

                        access = this.getAvailableItems(data.mediaType);

                        if (access.cpmVideoAllowed) {
                            current = 'video';
                        } else if (access.cpcVideoAllowed) {
                            current = 'cpc-video';
                        }

                    } else {
                        current = 'creatives';
                    }
                }

                return [current];
            }

            return this.getDefaultItems({
                mediaType: data.mediaType,
                cpmGroupType: data.cpmGroupType,
                adType: data.adType
            });
        },

        /**
         * Возвращает возможный набор типов выбора креативов
         * @param {Object} data
         * @param {String} data.mediaType
         * @param {String} [data.cpmGroupType]
         * @param {String} [data.adType]
         * @returns {Array}
         */
        getDefaultItems: function(data) {
            switch (data.mediaType) {
                case 'text':
                    if (data.adType === 'image_ad') return ['images', 'creatives'];

                    if (data.adType === 'cpc_video') return ['cpc-video'];

                    return ['images', 'creatives', 'cpc-video'];

                case 'mobile_content':
                    if (data.adType === 'image_ad') return ['images', 'creatives'];

                    if (data.adType === 'cpc_video') return ['cpc-video'];

                    return ['images', 'creatives', 'cpc-video'];

                case 'mcbanner':
                    return ['images'];

                case 'cpm_banner':
                case 'cpm_deals':
                    if (data.cpmGroupType === 'cpm_video') return ['video'];

                    if (data.cpmGroupType === 'cpm_audio') return ['audio'];

                    if (data.cpmGroupType === 'cpm_banner') return ['creatives'];

                    if (data.cpmGroupType === 'cpm_outdoor') return ['outdoor-video'];

                    if (data.cpmGroupType === 'cpm_indoor') return ['indoor-video'];

                    if (data.cpmGroupType === 'cpm_geoproduct') return ['geoproduct'];

                    return ['creatives', 'video', 'audio', 'outdoor-video', 'geoproduct', 'indoor-video'];

                case 'cpm_yndx_frontpage':
                    return ['creatives'];

                default:
                    return ['all'];
            }
        },

        /**
         * Возвращает права для отображения типа выбора креативов
         * @param {String} mediaType
         * @returns {Object}
         */
        getAvailableItems: function(mediaType) {
            return {
                loadingImageAllowed: !u.campaign.isCpm(mediaType),
                creativesAllowed: mediaType !== 'mcbanner' && mediaType !== 'cpm_yndx_frontpage',
                html5CreativesAllowed: u.campaign.isCpm(mediaType),
                cpmVideoAllowed: u.campaign.isCpm(mediaType) && u.consts('rights').allowedCpmVideoBanners &&
                    mediaType !== 'cpm_yndx_frontpage',
                cpmAudioAllowed: u.campaign.isCpm(mediaType) && u.consts('rights').cpmAudioEnabled &&
                    mediaType !== 'cpm_yndx_frontpage',
                cpmOutdoorAllowed: u.campaign.isCpm(mediaType) &&
                    mediaType !== 'cpm_yndx_frontpage',
                cpmGeoProduct: u.campaign.isCpm(mediaType) && u.consts('rights').cpmGeoProductEnabled &&
                    mediaType !== 'cpm_yndx_frontpage',
                cpmIndoorAllowed: u.campaign.isCpm(mediaType) &&
                    mediaType !== 'cpm_yndx_frontpage',
                cpcVideoAllowed: (mediaType === 'text' || mediaType === 'mobile_content') && u.consts('rights').allowedCpcVideoBanners,
            };
        }
    }
});
