BEM.MODEL.decl('b-image-add-loader', {

    image: 'object',

    creative: 'object',

    name: {
        type: 'string',
        dependsFrom: ['image', 'creative'],
        calculate: function() {
            return u['b-image-add-loader']
                .getName(this.get('image'), this.get('creative'));
        },
        format: u.escapeHTML
    },

    isImageLoaded: {
        type: 'boolean',
        dependsFrom: ['image', 'creative'],
        calculate: function() {
            return !u['b-image-add-loader'].isEmptyImage(this.get('image')) ||
                !u['b-image-add-loader'].isEmptyCreative(this.get('creative'));
        }
    },

    buttonText: {
        type: 'string',
        dependsFrom: ['isImageLoaded'],
        calculate: function() {
            return this.get('isImageLoaded') ? iget2('b-image-add-loader', 'izmenit', 'Изменить') : iget2('b-image-add-loader', 'dobavit', 'Добавить');
        }
    },

    needDisabled: {
        type: 'boolean',
        default: false
    }

}, {
    setImage: function(image) {
        this.set('image', image);
        this.set('creative', null);
    },

    setCreative: function(creative) {
        this.set('creative', creative);
        this.set('image', null);
    }
});
