block('b-import-csv').elem('actions').content()(function() {

    var ctx = this.ctx,
        agencies = ctx.agencies || [],
        allow = ctx.allow || {},
        service = ctx.service || {},
        forAgency,
        forAgencies;

    if (allow.createCampaign && (agencies.length || allow.createBySubclient) && ctx.notAgencyControl) {
        if (ctx.isAnyClient && !allow.createBySubclient && agencies.length === 1) {
            forAgency = agencies[0].login;
        } else {
            forAgencies = agencies.map(function(agency) {
                return {
                    elem: 'option',
                    attrs: { value: agency.login },
                    content: iget2('b-import-csv', 'v-agentstvo', 'в агентство') + ' &#171;' + agency.agency_name + '&#187;'
                };
            });

            if (allow.createBySubclient && (service.bySelf || service.byManager)) {
                forAgencies.unshift({
                    elem: 'option',
                    attrs: { value: '' },
                    content: service.bySelf ?
                        iget2('b-import-csv', 'dlya-samostoyatelnogo-obsluzhivaniya', 'для самостоятельного обслуживания') : iget2('b-import-csv', 'na-obsluzhivanie-menedzherom', 'на обслуживание менеджером')
                });
            }
        }
    }

    return [
        iget2('b-import-csv', 'sozdat-novuyu-kampaniyu', 'создать новую кампанию'),
        forAgency && {
            block: 'b-hidden',
            mix: [{
                block: 'b-import-csv',
                elem: 'hidden'
            }],
            attrs: {
                name: 'for_agency',
                value: forAgency
            }
        },
        forAgencies && [
            '&nbsp;',
            {
                block: 'select',
                mods: { disabled: ctx.disabled },
                name: 'for_agency',
                content: [
                    {
                        block: 'button'
                    },
                    {
                        elem: 'control',
                        content: forAgencies
                    }
                ]
            }
        ]
    ];
});
