block('b-import-csv')(

    addJs()(function() {
        return {
            currency: this.ctx.currency
        };
    }),

    content()(
        match(function() {
            return true;
        })(function() {
            return {
                block: 'b-layout-form',

                mods: {
                    layout: '27-71'
                },

                mixes: {
                    label: [{
                        block: 'b-import-csv',
                        elem: 'form-label'
                    }],
                    control: [{
                        block: 'b-import-csv',
                        elem: 'form-control'
                    }],
                    submit: [{
                        block: 'b-import-csv',
                        elem: 'form-submit'
                    }]
                },

                submit: {
                    block: 'button',
                    mods: {
                        disabled: 'yes',
                        type: 'submit',
                        theme: 'action'
                    },
                    type: 'submit',
                    content: iget2('b-import-csv', 'prodolzhit', 'Продолжить')
                },

                method: 'GET',

                action: this.ctx.action,

                attrs: {
                    name: 'accept'
                },

                hiddenInputs: [
                    'cmd', 'ulogin', 'retpath', 'svars_name',
                    'import_format', 'choosed_csv_camp', 'destination_camp'
                ].map(function(prop) {
                    return {
                        name: prop,
                        value: this.ctx.formProperties[prop] || '',
                        mix: [{
                            block: 'b-import-csv',
                            elem: 'hidden-' + prop.replace(/_/g, '-')
                        }]
                    };
                }, this),

                rows: [
                    {
                        label: iget2('b-import-csv', 'fayl', 'Файл'),
                        control: {
                            block: 'b-file-preloader',
                            name: 'xls',
                            url: this.ctx.action,
                            data: this.ctx.uploadProperties,
                            timeout: 600000
                        }
                    },
                    {
                        label: iget2('b-import-csv', 'kampaniya', 'Кампания'),
                        mix: [{
                            block: 'b-import-csv',
                            elem: 'campaigns-row',
                            elemMods: { hidden: 'yes' }
                        }],
                        control: {
                            block: 'select',
                            mods: {
                                disabled: 'yes'
                            },
                            content: [
                                {
                                    block: 'button'
                                },
                                {
                                    elem: 'control'
                                }
                            ]
                        }
                    },
                    {
                        label: iget2('b-import-csv', 'region', 'Регион'),
                        control: {
                            block: 'checkbox',
                            mods: {
                                disabled: 'yes'
                            },
                            mix: [{
                                block: 'b-import-csv',
                                elem: 'region-checkbox'
                            }],
                            checkboxAttrs: { name: 'set_common_geo', value: '1' },
                            text: iget2('b-import-csv', 'ustanovit-region-dlya-vseh', 'установить регион для всех загружаемых объявлений')
                        }
                    },

                    applyCtx({
                        block: 'b-import-csv',
                        elem: 'region-box',
                        elemMods: { hidden: 'yes' },
                        campaign: this.ctx.campaign
                    }),
                    {
                        label: iget2('b-import-csv', 'deystvie', 'Действие'),
                        control: {
                            block: 'b-import-csv',
                            elem: 'actions',
                            agencies: this.ctx.agencies,
                            allow: this.ctx.allow,
                            service: this.ctx.service,
                            notAgencyControl: this.ctx.notAgencyControl,
                            isAnyClient: this.ctx.isAnyClient,
                            disabled: 'yes'
                        }
                    },
                    {
                        label: iget2('b-import-csv', 'bid', 'Ставка'),
                        control: applyCtx({
                            block: 'b-csv-set-phrases-prices',
                            mix: {
                                block: 'b-import-csv',
                                elem: 'click-cost'
                            },
                            currency: this.ctx.currency
                        })
                    }
                ]

            };
        }),

        match(function() {
            return hasLoginRights('superreader_control');
        })(function() {
            return iget2('b-import-csv', 'nevozmozhno-zagruzit-csv-fayl', 'Невозможно загрузить CSV-файл под суперсмотрящим.');
        })
    )

);
