/**
 * @namespace
 * @name ImportCSV
 */
BEM.DOM.decl('b-import-csv', {

    onSetMod: {
        js: function() {
            this._availableCampaigns = [];

            this._filePreloader = this.findBlockInside('b-file-preloader');

            this._submitButton = this.findBlockInside({ block: 'button', modName: 'type', modVal: 'submit' });
            this._actions = this.elemInstance('actions');
            this._regionsSelector = this.findBlockInside('b-regions-selector');
            this._regionCheckbox = this.findBlockOn('region-checkbox', 'checkbox');
            this._regionBox = this.elemInstance('region-box');

            this._campainsBox = this.elemInstance('campaigns-row');
            this._campains = this._campainsBox.findBlockInside('select');

            this._pricesConstructor = this.findBlockInside('b-csv-set-phrases-prices');

            this._togglePaneLock();

            this._initEvents();
        },

        locked: function(modName, modValue) {
            var disabled = modValue ? 'yes' : '';

            disabled && this._regionCheckbox.delMod('checked');
            this._regionCheckbox.setMod('disabled', disabled);
            this.trigger(modName, !!modValue);

        }
    },

    /**
     * Делает определенный набор контролов активными/неактивными
     * в зависимости от параметров
     * @param {Boolean} needDisabled
     * @param {Object} [camp]
     * @private
     */
    _toggleDisabledControls: function(needDisabled, camp) {
        var disabled = needDisabled ? 'yes' : '';

        [
            this._regionsSelector,
            this._actions,
            this._submitButton
        ].forEach(function(block) {
            block.setMod('disabled', disabled);
        });

        this._actions.findBlocksInside('select').forEach(function(select) {
            select.setMod('disabled', disabled);
        });

        this._campains.setMod('disabled', camp ? '' : disabled);

        this._pricesConstructor.setDisabled({ isDisabled: disabled });
    },

    /**
     * Читает hidden поле формы
     * @param {String} name
     * @returns {String}
     */
    getFormProperty: function(name) {
        return this.elem('hidden-' + name.replace(/_/g, '-')).val();
    },

    /**
     * Задает hidden поле формы
     * @param {String} name
     * @param {String|Number} value
     */
    _setFormProperty: function(name, value) {
        this.elem('hidden-' + name.replace(/_/g, '-')).val(value);
    },

    /**
     * Инициализация событий загрузки файла, смены состояния чекбокса установки региона,
     * выбора кампании и изменения модели конструктора ставок
     * @private
     */
    _initEvents: function() {
        this._filePreloader
            .on('reset', this._togglePaneLock, this)
            .on('error', this._togglePaneLock, this)
            .on('uploaded', this._togglePaneLock, this);

        this._regionCheckbox.on('change', function(event, data) {
            var checked = data.checked,
                geoErrors = this._geoErrors,
                warnings = this._warnings;

            warnings.length && this._filePreloader.processErrors({ warnings: warnings });
            if (geoErrors.length) {
                this._filePreloader.processErrors({ errors: checked ? [] : geoErrors });
                this._submitButton.setMod('disabled', checked ? '' : 'yes');
            }

            this._regionBox.setMod('hidden', checked ? '' : 'yes');
        }, this);

        this._campains.on('change', function(e, data) {
            var camp = this._availableCampaigns[data.index],
                parseErrors = camp && camp.parse_errors || [],
                parseWarnings = camp && camp.parse_warnings || [];

            if (data.index > -1) {
                this._filePreloader.processErrors({
                    errors: parseErrors,
                    warnings: parseWarnings
                });

                this
                    .setMod('locked', parseErrors.length ? 'yes' : '')
                    ._toggleDisabledControls(!!parseErrors.length, camp);
            }

            this._setFormProperty('choosed_csv_camp', e.target.val());
        }, this);

        this._pricesConstructor.on('validated', function(e, data) {
            this._submitButton.setMod('disabled', data.valid ? '' : 'yes');
        }, this);

        return this;
    },

    /**
     * Включает/выключает панель, зависящую от того, загружен ли нужный файл
     * @param {jQuery.Event} [e]
     * @param {Object} [data]
     * @private
     */
    _togglePaneLock: function(e, data) {
        var hasDataWithoutCommonErrors = data && !(data.errors || []).length,
            firstCampaign = data && data.available_csv_campaigns && data.available_csv_campaigns[0],
            hasFirstCampaignErrors = firstCampaign && !!(firstCampaign.parse_errors || []).length;

        this._updateDependencies(data);

        BEM.DOM.update(this.elem('selected-file-extension'), this._filePreloader.getExtension());

        if (firstCampaign) {
            this
                .setMod('locked', hasFirstCampaignErrors ? 'yes' : '')
                ._toggleDisabledControls(hasFirstCampaignErrors, firstCampaign);
        } else {
            this
                .setMod('locked', hasDataWithoutCommonErrors ? '' : 'yes')
                ._toggleDisabledControls(!hasDataWithoutCommonErrors);
        }
    },

    /**
     * Обновляет hidden поля, блок с действиями и предупреждениями (если таковые имеются)
     * @param {Object} [data] пришедшие при загрузке файла данные без ошибок
     * @private
     */
    _updateDependencies: function(data) {
        var uploadedFileId = '',
            errors,
            geoErrors,
            warnings;

        this._availableCampaigns = [];

        if (data) {
            data.svars_name && (uploadedFileId = data.svars_name);

            data.errors && (errors = data.errors.filter(function(text) { return !!text }));
            data.warnings && (warnings = data.warnings.filter(function(text) { return !!text }));
            data.geo_errors && (geoErrors = data.geo_errors.filter(function(text) { return !!text }));

            this._availableCampaigns = data.available_csv_campaigns || [];

            this._availableCampaigns.length || this._filePreloader.processErrors({
                errors: errors,
                warnings: warnings
            });
        }

        this._campains.setOptions(this._availableCampaigns.map(function(camp, index) {
            return {
                item: 'option',
                value: camp.camp_number,
                content: camp.camp_name,
                selected: index === 0
            };
        }));

        this._setFormProperty('svars_name', uploadedFileId);

        this._campainsBox.setMod('hidden', this._availableCampaigns.length > 1 ? '' : 'yes');

        this._warnings = warnings;
        this._geoErrors = geoErrors;
    }

});
