block('b-import-xls').elem('actions')(

    js()(function() {
        return {
            campaigns: this.ctx.campaigns,
            campLimitError: this.ctx.campLimitError,
            hasMediaControl: this.ctx.hasMediaControl,
            hasSupportControl: this.ctx.hasSupportControl
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            agencies = ctx.agencies || [],
            allow = ctx.allow || {},
            service = ctx.service || {},
            campaigns = ctx.campaigns,
            hasCampaigns = !!campaigns.length,
            campaignsWithoutMobile = campaigns.filter(function(campaign) {
                return campaign.mediaType !== 'mobile_content';
            }),
            destination = 'new',
            forAgency,
            forAgencies;

        if (ctx.hasMediaControl) {
            destination = 'media';
        }

        if (ctx.hasSupportControl) {
            destination = 'other';
        }

        if (allow.createCampaign && (agencies.length || allow.createBySubclient) && ctx.notAgencyControl) {
            if (ctx.isAnyClient && !allow.createBySubclient && agencies.length === 1) {
                forAgency = agencies[0].login;
            } else {
                forAgencies = agencies.map(function(agency) {
                    return {
                        elem: 'option',
                        attrs: { value: agency.login },
                        content: iget2('b-import-xls', 'v-agentstvo', 'в агентство') + ' &#171;' + agency.agency_name + '&#187;'
                    };
                });

                if (allow.createBySubclient && (service.bySelf || service.byManager)) {
                    forAgencies.unshift({
                        elem: 'option',
                        attrs: { value: '' },
                        content: service.bySelf ?
                            iget2('b-import-xls', 'dlya-samostoyatelnogo-obsluzhivaniya', 'для самостоятельного обслуживания') : iget2('b-import-xls', 'na-obsluzhivanie-menedzherom', 'на обслуживание менеджером')
                    });
                }
            }
        }

        return [
            {
                block: 'radiobox',
                mods: { disabled: ctx.disabled },
                name: 'destination_camp',
                value: destination,
                content: [
                    hasCampaigns && {
                        elem: 'container',
                        mix: [{
                            block: 'b-import-xls',
                            elem: 'action',
                            elemMods: {
                                hidden: 'yes',
                                change: 'campaign'
                            }
                        }],
                        content: {
                            elem: 'radio',
                            controlAttrs: { value: 'old' },
                            content: [
                                iget2('b-import-xls', 'izmenit-kampaniyu', 'изменить кампанию'),
                                '&nbsp;',
                                '&#8470;',
                                '&nbsp;',
                                {
                                    block: 'b-import-xls',
                                    elem: 'campaign-description'
                                },
                                {
                                    block: 'b-hidden',
                                    mix: [{
                                        block: 'b-import-xls',
                                        elem: 'hidden',
                                        elemMods: { related: 'old' }
                                    }],
                                    attrs: { name: 'cid' }
                                }
                            ]
                        }
                    },
                    allow.loadToMediaPlan && !!campaignsWithoutMobile.length && {
                        elem: 'container',
                        mix: [{
                            block: 'b-import-xls',
                            elem: 'action',
                            elemMods: {
                                hidden: 'yes',
                                change: 'mediaplan'
                            }
                        }],
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: { value: 'media' },
                                content: iget2('b-import-xls', 'zagruzit-v-mediaplan', 'загрузить в медиаплан')
                            },
                            '&nbsp;',
                            {
                                block: 'b-campaigns-select',
                                mix: {
                                    block: 'b-import-xls',
                                    elem: 'media-campaigns-select'
                                },
                                mods: {
                                    disabled: ctx.disabled,
                                    related: 'media'
                                },
                                inputHint: iget2('b-import-xls', 'nayti-po-nomeru-ili', 'Найти по номеру или названию'),
                                emptyHint: iget2('b-import-xls', 'net-kampaniy-sootvetstvuyushchih-filtru', 'Нет кампаний, соответствующих фильтру'),
                                name: 'cid',
                                campaigns: campaignsWithoutMobile
                            }
                        ]
                    },
                    allow.createCampaign && {
                        elem: 'container',
                        mix: [{
                            block: 'b-import-xls',
                            elem: 'action'
                        }],
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: { value: 'new' },
                                content: [
                                    iget2('b-import-xls', 'sozdat-novuyu-kampaniyu', 'создать новую кампанию'),
                                    forAgency && {
                                        block: 'b-hidden',
                                        mix: [{
                                            block: 'b-import-xls',
                                            elem: 'hidden',
                                            elemMods: { related: 'new' }
                                        }],
                                        attrs: {
                                            name: 'for_agency',
                                            value: forAgency
                                        }
                                    }
                                ]
                            },
                            ctx.campLimitError && [
                                '&nbsp;',
                                {
                                    block: 'icon',
                                    mods: { 'size-13': 'question', theme: 'light' },
                                    attrs: { title: ctx.campLimitError }
                                }
                            ],
                            forAgencies && [
                                '&nbsp;',
                                {
                                    block: 'select',
                                    mods: {
                                        disabled: ctx.disabled,
                                        related: 'new'
                                    },
                                    name: 'for_agency',
                                    content: [
                                        {
                                            block: 'button'
                                        },
                                        {
                                            elem: 'control',
                                            content: forAgencies
                                        }
                                    ]
                                }
                            ]
                        ]
                    },
                    hasCampaigns && {
                        elem: 'container',
                        mix: [{
                            block: 'b-import-xls',
                            elem: 'action',
                            elemMods: {
                                hidden: 'yes',
                                change: 'other-campaign'
                            }
                        }],
                        content: [
                            {
                                elem: 'radio',
                                controlAttrs: { value: 'other' },
                                content: iget2('b-import-xls', 'dobavit-v-sushchestvuyushchuyu-kampaniyu', 'добавить в существующую кампанию')
                            },
                            '&nbsp;',
                            {
                                block: 'b-import-xls',
                                elem: 'other-campaigns-select-wrapper'
                            },
                            {
                                block: 'b-import-xls',
                                elem: 'note',
                                content: ['(', iget2('b-import-xls', 'obyavleniya-iz-fayla-budut', 'объявления из файла будут добавлены к существующим'), ')']
                            }
                        ]
                    }
                ]
            },
            {
                block: 'checkbox',
                mix: [{
                    block: 'b-import-xls',
                    elem: 'destination-checkbox'
                }],
                mods: {
                    related: 'destination',
                    disabled: ctx.disabled,
                    checked: 'yes'
                },
                text: iget2('b-import-xls', 'otpravlyat-novye-obyavleniya-na', 'отправлять новые объявления на модерацию'),
                checkboxAttrs: {
                    name: 'send_to_moderation',
                    value: 1
                }
            },
            {
                block: 'checkbox',
                mix: [{
                    block: 'b-import-xls',
                    elem: 'destination-checkbox'
                }],
                mods: {
                    related: 'destination',
                    disabled: ctx.disabled
                },
                text: iget2('b-import-xls', 'ne-izmenyat-stavki-u', 'не изменять ставки у существующих фраз'),
                checkboxAttrs: {
                    name: 'dont_change_prices',
                    value: 1
                }
            },
            {
                elem: 'warnings',
                hidden: ctx.disabled ? 'yes' : ''
            }
        ];
    })
);
