/**
 * @namespace
 * @name ImportXLSActions
 */
BEM.DOM.decl({ block: 'b-import-xls', elem: 'actions' }, {

    onSetMod: {
        js: function() {
            this._warningsBlock = this.elemInstance('warnings');
            this._radioGroup = this.findBlockInside('radiobox');

            this._relatedCheckboxes = this.findBlocksInside({
                block: 'checkbox',
                modName: 'related',
                modVal: 'destination'
            });

            this._radioGroup.on('change', function() {
                this._toggleWarnings();

                this._toggleRelatedElements();
            }, this);
        },

        disabled: function(modName, modValue) {
            var radioGroup = this._radioGroup;

            radioGroup.setMod('disabled', modValue ? 'yes' : '');

            if (this.params.campLimitError) {
                radioGroup.elemInstances('control').forEach(function(control) {
                    var radio = control.domElem;

                    if (radio.val() == 'new') {
                        radioGroup.setMod(radioGroup.closestElem(radio, 'radio'), 'disabled', 'yes');

                        return true;
                    }
                });
            }

            modValue && this._setDefaultRadio();

            this._toggleRelatedElements();
        }
    },

    /**
     * Установка сопровождающей информации для выбора изменяемой кампании и отображение самого контрола выбора
     * @param {String} campaignId
     * @param {String} campaignName
     * @returns {ImportXLSActions}
     */
    setChangingCampaign: function(campaignId, campaignName) {
        var hidden, related;

        hidden = this.elemInstance('hidden', 'related', 'old');

        if (!hidden) return this;

        related = hidden.getMod('related');

        campaignId || (campaignId = '');
        campaignName || (campaignName = '');

        if (!campaignId) {
            // при сбросе выставляем иное дефолтное значение радио, если радио выбрано "изменение кампании"
            related === this._radioGroup.val() && this._setDefaultRadio();
        } else {
            this._radioGroup.val(related);
        }

        // прячем контрол выбора изменения кампании, если этот вариант не предусмотрен текущим состоянием
        this.elemInstance('action', 'change', 'campaign').setMod('hidden', !campaignId ? 'yes' : '');

        hidden.domElem.val(campaignId);

        this.elem('campaign-description').text(campaignId + (campaignName ? ' ' + campaignName : ''));

        this._toggleRelatedHidden();

        return this;
    },

    /**
     * Переопределяет список селектов выбора кампании с учетом перерисовавшихся селектов
     * @returns {ImportXLSActions}
     */
    adjustRelatedSelects: function() {
        this._relatedSelects = this._radioGroup.findBlocksInside('select');

        return this;
    },

    /**
     * Корректирует пункт "добавить в существующую кампанию" в зависимости от типа кампании
     * @param {String} mediaType
     * @returns {ImportXLSActions}
     */
    adjustCampaignsList: function(mediaType) {
        if (!this.elem('other-campaigns-select-wrapper').length) return this;

        var campaigns = this.params.campaigns.filter(function(camp) {
            return camp.mediaType == mediaType;
        });

        // прячем контрол выбора добавления в существующую кампанию, если нет кампаний с данным mediaType
        this.elemInstance('action', 'change', 'other-campaign').setMod('hidden', !campaigns.length ? 'yes' : '');

        if (campaigns.length) {
            BEM.DOM.update(
                this.elem('other-campaigns-select-wrapper'),
                BEMHTML.apply({
                    block: 'b-campaigns-select',
                    mix: { block: 'b-import-xls', elem: 'other-campaigns-select' },
                    mods: {
                        disabled: 'yes',
                        related: 'other'
                    },
                    inputHint: iget2('b-import-xls', 'nayti-po-nomeru-ili', 'Найти по номеру или названию'),
                    emptyHint: iget2('b-import-xls', 'net-kampaniy-sootvetstvuyushchih-filtru', 'Нет кампаний, соответствующих фильтру'),
                    name: 'cid',
                    campaigns: campaigns
                })
            );
        }

        return this;
    },

    /**
     * Корректирует пункт "добавить в медиаплан" в зависимости от типа кампании
     * @param {String} mediaType
     * @returns {ImportXLSActions}
     */
    adjustMediaplansList: function(mediaType) {
        var elemInstance = this.elemInstance('action', 'change', 'mediaplan');

        // прячем контрол выбора изменения медиаплана, если кампания типа РМП
        elemInstance && elemInstance.setMod('hidden', mediaType == 'mobile_content' ? 'yes' : '');

        return this;
    },

    /**
     * Установка хэша с активными блоками warning
     * @param {Object} [warnings]
     * @returns {ImportXLSActions}
     */
    setWarningMessages: function(warnings) {
        var warnBlock = this._warningsBlock,
            parent = this.getParent();

        warnBlock.reset();

        warnings && Object.keys(warnings).forEach(function(key) {
            warnBlock.setWarning(key, warnings[key]);
        });

        this._toggleWarnings();
        // ошибка про устаревший шаблон должна отображаться рядом с типом кампании
        parent.setMod(
            parent.elem('warning', 'type', 'campaign-type-not-defined'),
           'hidden',
            warnings && warnings['campaign-type-not-defined'] ? '' : 'yes');

        this._toggleSubmitControl();

        return this;
    },

    /**
     * В зависимости, есть ли сообщение о допустимом лимите загрузки новых кампаний,
     * значение по умолчанию вариативно
     * @private
     */
    _setDefaultRadio: function() {
        var params = this.params;

        this._radioGroup.val(
            params.campLimitError || params.hasSupportControl ?
                'other' :
                params.hasMediaControl ? 'media' : 'new' );
    },

    /**
     * В зависимости от выбранных действий прячет/показывает зависимые элементы интерфейса,
     * блокирует/разблокирует submit кнопку и меняет cmd параметр формы
     * @returns {ImportXLSActions}
     * @private
     */
    _toggleRelatedElements: function() {
        this.getParent()
            .setFormProperty('cmd', this._radioGroup.val() === 'media' ? 'importCampToMediaplanXLS' : 'importCampXLS');

        return this
            ._toggleRelatedHidden()
            ._toggleRelatedSelects()
            ._toggleRelatedCheckboxes()
            ._toggleSubmitControl();
    },

    /**
     * Управление зависимыми hidden элементами формы
     * @returns {ImportXLSActions}
     * @private
     */
    _toggleRelatedHidden: function() {
        var value;

        this._isDisabled() ||
            (value = this._radioGroup.val());

        this.elemInstances('hidden').forEach(function(hidden) {
            var hiddenElem = hidden.domElem;

            hiddenElem.attr('disabled', !value || !hiddenElem.val() || !hidden.hasMod('related', value));
        });

        return this;
    },

    /**
     * Управление включением/выключением выпадающих списков, зависящих от выбранных радио кнопок
     * @returns {ImportXLSActions}
     * @private
     */
    _toggleRelatedSelects: function() {
        var value;

        this._isDisabled() ||
            (value = this._radioGroup.val());

        this._relatedSelects.forEach(function(select) {
            select.setMod('disabled', value && select.hasMod('related', value) ? '' : 'yes');
        });

        return this;
    },

    /**
     * Управление включением/выключением чекбоксов, зависящих от выбранных радио кнопок
     * @returns {ImportXLSActions}
     * @private
     */
    _toggleRelatedCheckboxes: function() {
        var disabled = this._isDisabled() || this._radioGroup.val() === 'media' ? 'yes' : '';

        this._relatedCheckboxes.forEach(function(checkbox) {
            checkbox.setMod('disabled', disabled);
        });

        return this;
    },

    /**
     * Управление включением/выключением submit кнопки
     * @returns {ImportXLSActions}
     * @private
     */
    _toggleSubmitControl: function() {
        var actionsDisabled = this._isDisabled(),
            delegateSubmitControl = !actionsDisabled && this._canDelegateSubmitControl();

        this._warningsBlock.setMod('hidden', delegateSubmitControl ? '' : 'yes');

        delegateSubmitControl || this.getParent().getSubmitBlock().setMod('disabled', actionsDisabled ? 'yes' : '');

        return this;
    },

    /**
     * Управление скрытием/показом предупреждений в зависимости от состояния формы
     * @private
     */
    _toggleWarnings: function() {
        var warnBlock = this._warningsBlock,
            val = this._radioGroup.val(),
            canModifyOld = !!this.elem('hidden', 'related', 'old').val(),
            disabled;

        // если можно выбрать действие изменения кампании, то предупреждения скрыты при выборе других действий
        if (canModifyOld) {
            disabled = val !== 'old';

            warnBlock.toggleDisabled('without-any-bids', disabled);
            warnBlock.toggleDisabled('lost-phrases', disabled);
            warnBlock.toggleDisabled('lost-banners', disabled);
            warnBlock.toggleDisabled('lost-groups', disabled);
            warnBlock.toggleDisabled('changes-minus-words', disabled);
            warnBlock.toggleDisabled('banners-without-bids', disabled);
            warnBlock.toggleDisabled('different-currency', disabled);
        } else {
            warnBlock.toggleDisabled('without-any-bids', val === 'new');
        }
    },

    /**
     * Проверка признака выключения возможности делать выбор (радио кнопки в состоянии disabled)
     * @returns {Boolean}
     * @private
     */
    _isDisabled: function() {
        return this._radioGroup.hasMod('disabled', 'yes');
    },

    /**
     * Проверка возможности передать управление блокировкой submit кнопки блоку warnings
     * @returns {Boolean}
     * @private
     */
    _canDelegateSubmitControl: function() {
        return this._warningsBlock.hasWarnings();
    }

});
