/**
 * @namespace
 * @name ImportXLSRegionBox
 */
BEM.DOM.decl({ block: 'b-import-xls', elem: 'region-box' }, {

    /**
     * Блок выбора региона
     */
    _campaignRegions: null,

    onSetMod: {
        js: function() {
            this._campaignRegions = this.findBlockInside('b-campaign-region');

            this.toggleVisibility(this.hasMod('hidden', 'yes'));
        },

        hidden: function(modName, modValue) {
            this.toggleVisibility(!!modValue);
        }

    },

    /**
     * Изменяет состояние видимости для попапа выбора региона. Следит за
     * включением/выключением hidden поля с ид. региона.
     * @param {Boolean} hidden
     */
    toggleVisibility: function(hidden) {
        var geoHidden = this._campaignRegions.findBlockInside('b-regions-selector').elem('geo-hidden');

        // если блок выключен, нужно выключить hidden, чтобы он не фонил
        geoHidden.attr('disabled', hidden);
    }

});
