/**
 * @namespace
 * @name ImportXLSWarning
 */
BEM.DOM.decl({ block: 'b-import-xls', elem: 'warning' }, {

    /**
     * Опциональная checkbox галка, которая дает "согласие" с варнингом
     */
    _agreebox: null,

    /**
     * Радиогруппа с предлагаемыми вариантами решения варнинга
     */
    _radiobox: null,

    /**
     * Блок с текстом с иконкой с сообщением варнинга
     */
    _iconText: null,

    onSetMod: {
        js: function() {
            this._agreebox = this.findBlockInside('checkbox');
            this._radiobox = this.findBlockInside('radiobox');
            this._iconText = this.findBlockInside('icon-text');

            this._agreebox && this._agreebox.on('change', function() {
                this.trigger('review');
            }, this);
        },

        hidden: function(modName, modValue) {
            if (this._agreebox) {
                modValue && this._agreebox.delMod('checked');

                this._agreebox.setMod('disabled', modValue);
            }

            if (this._radiobox) {
                this._radiobox.setMod('disabled', modValue);
            }
        }
    },

    /**
     * Задает сообщение для отображения из аргумента, если это непустая строка.
     * Если сообщение непустое выключает модификатор hidden, иначе - включает.
     * @param {String|Number} message
     * @param {Array} [descriptions]
     */
    setMessage: function(message, descriptions) {
        if (!this.hasMod('type', 'has-oversized-banners')) {
            if (descriptions && descriptions.length) {
                this._iconText.setText(BEMHTML.apply({
                    block: 'b-list',
                    tag: 'span',
                    mods: { style: 'expandable' },
                    content: [
                        { elem: 'header', content: message },
                        {
                            elem: 'list',
                            limit: 5,
                            content: descriptions.map(function(item) {
                                return { elem: 'item', content: ['&ndash;&nbsp;', u.hellipCut(item, 80)] };
                            }, this)
                        },
                        { elem: 'expand', content: iget2('b-import-xls', 'pokazat-vse', 'показать все') }
                    ]
                }));
            } else if (typeof message === 'string') {
                this._iconText.setText(message);
            }
        }

        this.setMod('hidden', !message ? 'yes' : '');
    },

    /**
     * Разрешен ли вопрос по данному предупреждению.
     * @returns {Boolean}
     */
    isResolved: function() {
        // имеет смысл только для блоков с чекбоксами (выключенные не должны влиять на решение)
        return !this._agreebox || this._agreebox.isDisabled() || this._agreebox.isChecked();
    }

});
