/**
 * @namespace
 * @name ImportXLSWarnings
 */
BEM.DOM.decl({ block: 'b-import-xls', elem: 'warnings' }, {

    /**
     * Хэш-объект с ключами включенных предупреждений
     * @type Object
     */
    _warnings: null,

    _disabled: null,

    onSetMod: {
        js: function() {
            this._warnings = {};

            this._disabled = {};

            this.elemInstances('warning').forEach(function(elemInstance) {
                elemInstance.on('review', this._toggleSubmitControl, this);
            }, this);
        },

        hidden: function(modName, modValue) {
            this._getActiveWarnings().forEach(function(warning) {
                warning.setMod('hidden', modValue);
            });

            this._toggleSubmitControl();
        }
    },

    toggleDisabled: function(elemName, disabled) {
        if (disabled) {
            if (!this._warnings[elemName]) return;

            this._disabled[elemName] = this._warnings[elemName];

            delete this._warnings[elemName];
        } else {
            if (!this._disabled[elemName]) return;

            this._warnings[elemName] = this._disabled[elemName];

            delete this._disabled[elemName];
        }

        this.getWarning(elemName).setMod('hidden', disabled ? 'yes' : '');

        this._toggleSubmitControl();
    },

    /**
     * Сброс предупреждений
     */
    reset: function() {
        var keys = Object.keys(this._disabled).concat(Object.keys(this._warnings));

        this._warnings = {};
        this._disabled = {};

        keys.map(function(elemName) {
            this.setWarning(elemName, isNaN(this._warnings[elemName]) ? '' : 0);
        }, this);
    },

    /**
     * Проверка, есть ли включенные элементы предупреждений
     * @returns {Boolean}
     */
    hasWarnings: function() {
        return !!this._getActiveWarnings().length;
    },

    /**
     * Задает/снимает (включает/выключает) предупреждение
     * @param {String} elemName
     * @param {String|Number} message
     */
    setWarning: function(elemName, message) {
        var parts,
            warning = this.getWarning(elemName);

        if (!warning) return;

        message ?
            (this._warnings[elemName] = message) :
            (delete this._warnings[elemName]);

        if (message && elemName === 'lost-phrases') {
            warning.setMessage(message.title, message.items);
        } else if (message && ['lost-banners', 'lost-groups'].indexOf(elemName) > -1) {
            parts = message.split(':');

            warning.setMessage(
                parts[0],
                parts[1]
                    .replace(/\"/g, '')
                    .replace(/\.$/g, '')
                    .replace(/^\s+|\s+$/g, '')
                    .split(','));
        } else {
            warning.setMessage(message);
        }
    },

    /**
     * Возвращает элемент предупреждения по его имени
     * @param {String} elemName
     * @returns {BEM}
     */
    getWarning: function(elemName) {
        return this.elemInstance('warning', 'type', elemName);
    },

    /**
     * Возвращает список включенных элементов предупреждений
     * @returns {BEM[]}
     * @private
     */
    _getActiveWarnings: function() {
        return Object.keys(this._warnings).map(this.getWarning, this);
    },

    /**
     * Опрашивает включенные предупреждения (все ли "согласны") и включает/выключает submit кнопку
     * @private
     */
    _toggleSubmitControl: function() {
        var disabled,
            warnings = this._getActiveWarnings();

        if (!warnings.length) return;

        disabled = !warnings.every(function(warning) { return warning.isResolved() });

        this.getParent().getSubmitBlock().setMod('disabled', disabled ? 'yes' : '');
    }

});
