block('b-import-xls')(

    addJs()(function() {
        return {
            regionConfirmText: iget2(
                'b-import-xls',
                'vybrannyy-region-budet-ustanovlen-101',
                'Выбранный регион будет установлен для всех загружаемых объявлений вместо регионов, указанных в xls-файле.'
            )
        };
    }),

    content()(
        match(function() {
            return true;
        })(function() {
            return {
                block: 'b-layout-form',

                mods: {
                    layout: '27-71'
                },

                mixes: {
                    label: [{
                        block: 'b-import-xls',
                        elem: 'form-label'
                    }],
                    control: [{
                        block: 'b-import-xls',
                        elem: 'form-control'
                    }],
                    submit: [{
                        block: 'b-import-xls',
                        elem: 'form-submit'
                    }]
                },

                submit: {
                    block: 'button',
                    mods: {
                        disabled: 'yes',
                        type: 'submit',
                        theme: 'action'
                    },
                    type: 'submit',
                    content: iget2('b-import-xls', 'prodolzhit', 'Продолжить')
                },

                method: 'GET',

                action: this.ctx.action,

                attrs: {
                    name: 'accept'
                },

                hiddenInputs: ['cmd', 'ulogin', 'retpath', 'svars_name'].map(function(prop) {
                    return {
                        name: prop,
                        value: this.ctx.formProperties[prop] || '',
                        mix: [{
                            block: 'b-import-xls',
                            elem: 'hidden-' + prop.replace(/_/g, '-')
                        }]
                    };
                }, this),

                rows: [
                    {
                        label: {
                            block: 'b-import-xls',
                            elem: 'camp-errors',
                            elemMods: { hidden: 'yes' }
                        }
                    },
                    {
                        label: iget2('b-import-xls', 'fayl', 'Файл'),
                        control: {
                            block: 'b-file-preloader',
                            name: 'xls',
                            url: this.ctx.action,
                            data: this.ctx.uploadProperties,
                            timeout: 600000
                        }
                    },
                    {
                        mixes: {
                            row: [{
                                block: 'b-import-xls',
                                elem: 'camp-type'
                            }]
                        },
                        control: [
                            {
                                block: 'b-import-xls',
                                elem: 'camp-type-cell',
                                elemMods: { hidden: 'yes' }
                            },
                            {
                                block: 'b-import-xls',
                                elem: 'warning',
                                elemMods: {
                                    type: 'campaign-type-not-defined',
                                    hidden: 'yes'
                                },
                                warning: iget2(
                                    'b-import-xls',
                                    'zagruzhen-ustarevshiy-shablon-fayla',
                                    'Загружен устаревший шаблон файла. Пожалуйста, используйте новый шаблон.'
                                )
                            }
                        ]
                    },
                    {
                        label: iget2('b-import-xls', 'region', 'Регион'),
                        control: {
                            block: 'checkbox',
                            mods: {
                                disabled: 'yes'
                            },
                            mix: [{
                                block: 'b-import-xls',
                                elem: 'region-checkbox'
                            }],
                            checkboxAttrs: { name: 'set_common_geo', value: '1' },
                            text: iget2('b-import-xls', 'ustanovit-region-dlya-vseh', 'установить регион для всех загружаемых объявлений')
                        }
                    },

                    applyCtx({
                        block: 'b-import-xls',
                        elem: 'region-box',
                        elemMods: { hidden: 'yes' },
                        campaign: this.ctx.campaign
                    }),

                    {
                        label: iget2('b-import-xls', 'deystvie', 'Действие'),
                        control: {
                            block: 'b-import-xls',
                            elem: 'actions',
                            agencies: this.ctx.agencies,
                            campaigns: this.ctx.campaigns,
                            campLimitError: this.ctx.campLimitError,
                            allow: this.ctx.allow,
                            service: this.ctx.service,
                            notAgencyControl: this.ctx.notAgencyControl,
                            isAnyClient: this.ctx.isAnyClient,
                            hasMediaControl: this.ctx.hasMediaControl,
                            hasSupportControl: this.ctx.hasSupportControl,
                            disabled: 'yes'
                        }
                    }
                ]

            };
        }),

        match(function() {
            return this.ctx.allow && !this.ctx.allow.createCampaign && !this.ctx.campaigns.length;
        })(function() {
            return iget2(
                'b-import-xls',
                'nevozmozhno-zagruzit-xls-xlsx',
                'Невозможно загрузить XLS/XLSX-файл. У клиента должна быть хотя бы одна кампания.'
            );
        }),

        match(function() {
            return hasLoginRights('superreader_control');
        })(function() {
            return iget2('b-import-xls', 'nevozmozhno-zagruzit-xls-xlsx-102', 'Невозможно загрузить XLS/XLSX-файл под суперсмотрящим.');
        })
    )
);
