/**
 * @namespace
 * @name ImportXLS
 */
BEM.DOM.decl('b-import-xls', {

    /**
     * Блок формы
     */
    _form: null,

    /**
     * Блок кнопки submit
     */
    _submitButton: null,

    /**
     * Блок checkbox включающий/выключающий блок выбора региона
     */
    _regionCheckbox: null,

    /**
     * Блок, хранящий в себе блок выбора региона
     */
    _regionBox: null,

    /**
     * Блок с действиями над загружаемым файлом
     */
    _actions: null,

    /**
     * Блок предзагрузки файла
     */
    _filePreloader: null,

    onSetMod: {
        js: function() {
            var regionCheckbox,
                confirmText;

            this._form = this.findBlockInside('b-layout-form');

            if (!this._form) return;

            this._filePreloader = this.findBlockInside('b-file-preloader');

            this._submitButton = this.findBlockInside({ block: 'button', modName: 'type', modVal: 'submit' });
            this._actions = this.elemInstance('actions');
            this._regionBox = this.elemInstance('region-box');
            this._regionCheckbox = this.findBlockOn('region-checkbox', 'checkbox');

            this._radiobox = this.findBlockInside('radiobox');

            this._radiobox.on('change', this._onActionChange, this);

            this.mediaSelect = this.findBlockOn('media-campaigns-select', 'select');
            this.otherSelect = this.findBlockOn('other-campaigns-select', 'select');

            this._toggleFormLock();

            this._filePreloader.on('post reset error uploaded', this._toggleFormLock, this);

            this._regionCheckbox.on('change', function(event, data) {
                var checked = data.checked,
                    geoErrors = this._geoErrors,
                    warnings = this._warnings;

                geoErrors && this._filePreloader.processErrors({ errors: !checked ? geoErrors : [] }) ||
                    warnings && this._filePreloader.processErrors({ warnings: warnings });

                geoErrors &&
                    this.getSubmitBlock().setMod('disabled', !checked ? 'yes' : '');

                this._regionBox.setMod('hidden', !checked ? 'yes' : '');
            }, this);

            confirmText = this.params.regionConfirmText;
            regionCheckbox = this._regionCheckbox;
            this._form.bindTo('submit', function(e) {
                regionCheckbox.isChecked() && !confirm(confirmText) && e.preventDefault();
            });
        },

        locked: function(modName, modValue) {
            var disabled = modValue ? 'yes' : '';

            this.getSubmitBlock().setMod('disabled', disabled);

            disabled && this._regionCheckbox.delMod('checked');

            this._regionCheckbox.setMod('disabled', disabled);
            this._actions.setMod('disabled', disabled);

            this._geoErrors &&
                this.getSubmitBlock().setMod('disabled', 'yes');
        }
    },

    /**
     * Возвращает ссылку на блок кнопки submit
     * @returns {BEM}
     */
    getSubmitBlock: function() {
        return this._submitButton;
    },

    /**
     * Читает hidden поле формы
     * @param {String} name
     * @returns {String}
     */
    getFormProperty: function(name) {
        return this.elem('hidden-' + name.replace(/_/g, '-')).val();
    },

    /**
     * Задает hidden поле формы
     * @param {String} name
     * @param {String|Number} value
     */
    setFormProperty: function(name, value) {
        this.elem('hidden-' + name.replace(/_/g, '-')).val(value);
    },

    /**
     * Включает/выключает панель, зависящую от того, загружен ли нужный файл
     * @param {jQuery.Event} [event]
     * @param {Object} [data]
     * @private
     */
    _toggleFormLock: function(event, data) {
        var hasData = data && !(data.errors && data.errors.length);

        this._updateDependencies(hasData ? data : null);

        BEM.DOM.update(this.elem('selected-file-extension'), this._filePreloader.getExtension());

        this.setMod('locked', !hasData ? 'yes' : '');
    },

    /**
     * Обновляет hidden поля, блок с действиями, типом кампании и предупреждениями (если таковые имеются)
     * @param {Object} data пришедшие при загрузке файла данные без ошибок
     * @private
     */
    _updateDependencies: function(data) {
        var uploadedFileId = '',
            changingCampaign = { cid: '', campName: '' },
            geoErrors,
            warnings,
            parseWarnings,
            warningMessages;

        if (data) {
            uploadedFileId = data.svars_name;

            changingCampaign.cid = data.cid;
            changingCampaign.campName = data.camp_name;
            changingCampaign.mediaType = data.mediaType;

            // в warnings есть пустые строки
            data.warnings && (warnings = data.warnings.filter(function(text) { return !!text }));
            data.geo_errors && (geoErrors = data.geo_errors.filter(function(text) { return !!text }));

            warnings && !warnings.length && (warnings = null);
            geoErrors && !geoErrors.length && (geoErrors = null);

            parseWarnings = data.parse_warnings_for_exists_camp;

            this.campErrors = {
                from: data.from_cid,
                errors: []
            };

            parseWarnings.changed_mobile_banners_type &&
                this.campErrors.errors.push(parseWarnings.changed_mobile_banners_type);
            parseWarnings.changed_desktop_banners_type &&
                this.campErrors.errors.push(parseWarnings.changed_desktop_banners_type);

            warningMessages = {
                'has-oversized-banners': data.has_oversized_banners,
                'lost-phrases': parseWarnings.lost_phrases,
                'lost-banners': parseWarnings.lost_banners,
                'lost-groups': parseWarnings.lost_groups,
                'changes-minus-words': parseWarnings.changes_minus_words,
                'without-any-bids': parseWarnings.without_any_bids,
                'banners-without-bids': parseWarnings.banners_without_bids,
                'different-currency': parseWarnings.different_currency,
                'campaign-type-not-defined': parseWarnings.campaign_type_not_defined
            };

            BEM.DOM.update(
                this.elem('camp-type-cell'),
                BEMHTML.apply({
                    block: 'b-campaign-type',
                    mediaType: changingCampaign.mediaType
                })
            );
        }

        this.setMod(this.elem('camp-type'), 'hidden', data ? '' : 'yes')
        this.setFormProperty('svars_name', uploadedFileId);

        this._changingCampaign = changingCampaign.cid;

        this._actions
            .setChangingCampaign(changingCampaign.cid, changingCampaign.campName)
            .adjustCampaignsList(changingCampaign.mediaType)
            .adjustMediaplansList(changingCampaign.mediaType)
            .adjustRelatedSelects()
            .setWarningMessages(warningMessages);

        geoErrors && this._filePreloader.processErrors({ errors: geoErrors }) ||
            warnings && this._filePreloader.processErrors({ warnings: warnings });

        this._geoErrors = geoErrors;
        this._warnings = warnings;

    },

    _onActionChange: function() {
        if (!this.campErrors.from) return;

        if (['media', 'other', 'old'].indexOf(this._radiobox.val()) != -1) {
            this._onCampaignChange();
        } else {
            this._setCampErrors();
        }
    },

    _getSelectedCampaign: function() {
        if (this._radiobox.val() == 'old') return this._changingCampaign || '';

        return this.findBlockOn(this._radiobox.val() + '-campaigns-select', 'select').val();
    },

    _onCampaignChange: function() {
        var cid = this._getSelectedCampaign(),
            campErrors = this.campErrors || {};

        if (cid == campErrors.from) {
            this._setCampErrors(campErrors.errors);
        } else {
            this._setCampErrors()
        }

    },

    _setCampErrors: function(errors) {
        if (this.getMod('locked') == 'yes' || this.campErrors) return;

        this._filePreloader.processErrors({ errors: errors }, 'camp');
        this.getSubmitBlock().toggleMod('disabled', 'yes', '', errors.length);
    }

});
