BEM.DOM.decl({ block: 'b-infoblock-collapser' }, {
    onSetMod: {
        js: function() {
            this._subMan = BEM.create('i-subscription-manager');
            this._subMan.on(this.findBlockInside('link', 'link'), 'click', function() {
                this.toggleMod('state', 'uncollapsed', 'collapsed');
            }, this);
        },

        state: function(modName, modVal) {
            this.trigger('stateChanged', { isCollapsed: modVal == 'collapsed' ? 'yes' : 'no' });
        }
    },

    /**
     * Установка внешнего контрола коллапса
     * @param {BEM.BLOCK} block - внешний коллапс-блок
     */
    setCollapserBlock: function(block) {
        this._subMan.on(block, 'click', function() {
            this.toggleMod('state', 'uncollapsed', 'collapsed');
        }, this);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();

        this.__base.apply(this, arguments);
    }
});
