/**
 * @param {String} this.params.newsFetchURL относительный URL до ручки получения отдельной новости
 */
block('b-infoblock-news')(

    js()(function() {
        return {
            newsUrl: this.ctx.newsUrl,
            newsFetchURL: this.ctx.newsFetchURL
        };
    }),

    mix()([{
        block: 'i-glue',
        js: { modelName: 'm-infoblock-state' }
    }]),

    content()(function() {
        return [
            {
                elem: 'header',
                content: [
                    {
                        block: 'b-infoblock-collapser',
                        state: (this.ctx.mods || {}).collapsed === 'yes' ? 'collapsed' : 'uncollapsed',
                        mix: { block: 'b-infoblock-news', elem: 'collapser' }
                    },
                    {
                        block: 'link',
                        mods: { pseudo: 'yes', theme: 'without-border' },
                        mix: { block: 'b-infoblock-news', elem: 'news-title' },
                        tag: 'span',
                        content: iget2('b-infoblock-news', 'novosti', 'Новости')
                    },
                    {
                        block: 'link',
                        attrs: { target: '_blank' },
                        mix: [{
                            block: 'b-infoblock-news',
                            elem: 'archive-link'
                        }],
                        url: this.ctx.newsUrl,
                        content: iget2('b-infoblock-news', 'ves-arhiv', 'Весь архив')
                    }
                ]
            },
            {
                elem: 'scrollable'
            },
            {
                block: 'link',
                mods: { pseudo: 'yes', theme: 'without-border' },
                mix: { block: 'b-infoblock-news', elem: 'more' },
                content: [
                    {
                        block: 'spin',
                        js: true,
                        mods: { theme: 'gray-16', progress: 'no' },
                        mix: { block: 'b-infoblock-news', elem: 'spin' }
                    },
                    iget2('b-infoblock-news', 'pokazat-eshchyo', 'Показать ещё')
                ]
            }
        ];
    }),

    elem('snippet').content()(function() {
        return this.ctx.content.map(function(item) {
            if (!item.link_url) return item.text;

            return {
                block: 'link',
                js: { modelId: item.modelId },
                mix: [{
                    block: 'b-infoblock-news',
                    elem: 'link'
                }],
                mods: {
                    theme: 'direct',
                    pseudo: 'yes'
                },
                attrs: { target: '_blank' },
                content: item.text,
                url: item.link_url
            };
        });
    })
);
