BEM.DOM.decl({ block: 'b-infoblock-news' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            u.graspSelf.call(this, {
                _collapser: 'b-infoblock-collapser inside collapser',
                _title: 'link inside news-title',
                _moreButton: 'link inside more',
                _spin: 'spin inside spin'
            });

            this._subMan = BEM.create('i-subscription-manager');
            this._subMan
                .on(this._collapser, 'stateChanged', function(e, data) {
                    this.setMod('collapsed', data.isCollapsed)
                }, this)
                .on(this._moreButton, 'click', this._addNextEvent, this);

            this._collapser.setCollapserBlock(this._title);
        }
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._subMan.dispose();

        this.__base.apply(this, arguments);
    },

    /**
     * Полная перерисовка блока (при открытии)
     * @param {BEM.MODEL.FIELD} modelsList коллекция моделей
     * @returns {$.Deferred}
     */
    repaint: function(modelsList) {
        var _this = this,
            promise;

        this._items = modelsList;
        this._count = modelsList.length();
        this._itemsIds = modelsList.map(function(eventModel) { return eventModel.get('ext_news_id') });

        this.setMod(this.elem('more'), 'empty', this._count == 0 ? 'yes' : '');

        promise = $.Deferred().resolve(this._items).promise();

        return promise.then(function(eventsList) {
            var elems = eventsList.map(function(eventModel) {
                return _this._buildSnippet(eventModel);
            });

            BEM.DOM.replace(_this.findElem('scrollable'), BEMHTML.apply({
                block: 'b-infoblock-news',
                elem: 'scrollable',
                content: elems
            }));

            (_this._lastDownloadedEvent == _this._itemsIds[_this._count - 1]) &&
                _this._moreButton.setMod('disabled', 'yes');

            // на каждую ссылку вешаем событие
            this.findBlocksInside('link', 'link').forEach(function(link) {
                link.on('click', this._onRead, this)
            }, this);
        }.bind(this));
    },

    /**
     * Добавление следующего по списку события-новости
     * @returns {Boolean} - была ли добавлена новость
     * @private
     */
    _addNextEvent: function() {
        var currentEventNo = this._itemsIds.indexOf(this._lastDownloadedEvent),
            idxToDownload = currentEventNo < this._count - 1 ? (currentEventNo + 1) : -1,
            needToBlockButton = currentEventNo == this._count - 2,
            eventToDownload = this._items.where({ ext_news_id: this._itemsIds[idxToDownload] })[0],
            uploadPromise,
            _this = this;

        if (!!eventToDownload && this._isFulfilledItem(eventToDownload)) {
            return false;
        }

        uploadPromise = this._provideData(eventToDownload);

        this._spin.setMod('progress', 'yes');

        uploadPromise.then(function(eventModel) {
            var scrollable = _this.findElem('scrollable'),
                events;

            BEM.DOM.append(scrollable, _this._buildSnippet(eventModel));

            // привязываем заново события ко всем ссылкам
            _this.findBlocksInside('link', 'link').forEach(function(link) {
                link
                    .un('click', _this._onRead, _this)
                    .on('click', _this._onRead, _this);
            }, _this);

            needToBlockButton && _this._moreButton.setMod('disabled', 'yes');

            _this._spin.setMod('progress', 'no');

            scrollable.scrollTop(scrollable[0].scrollHeight);

            return true;
        })
    },

    /**
     * Верстка новости по модели
     * @param {BEM.MODEL} eventModel - модель новости
     * @returns {String|undefined} - строка с html или undefined
     * @private
     */
    _buildSnippet: function(eventModel) {
        var langsFormats = {
                ru: 'DD MMMM YYYY',
                en: 'MMMM DD YYYY',
                ua: 'DD MMMM YYYY',
                tr: 'DD MMMM YYYY'
            },
            lang = u.consts('lang'),
            data = eventModel && eventModel.get('data'),
            // даты приходят строкой в некрасивом формате с "г" на конце
            date = data && u.moment(data.date, langsFormats[lang] || 'DD MMMM YYYY');
        this._lastDownloadedEvent = data ? eventModel.get('ext_news_id') : this._lastDownloadedEvent;

        return data ?
            BEMHTML.apply({
                block: 'b-infoblock-news',
                elem: 'event',
                content: [
                    {
                        elem: 'date',
                        content: [
                            u.moment(date).calendar(null, {
                                sameDay: '[' + iget2('b-infoblock-news', 'segodnya', 'Сегодня') + ']',
                                lastDay: '[' + iget2('b-infoblock-news', 'vchera', 'Вчера') + ']',
                                lastWeek: 'DD MMMM YYYY',
                                nextDay: '[' + iget2('b-infoblock-news', 'zavtra', 'Завтра') + ']',
                                nextWeek: 'DD MMMM YYYY',
                                sameElse: 'DD MMMM YYYY'
                            }),
                            eventModel.get('new') && {
                                elem: 'new-dot',
                                mods: { 'model-id': eventModel.id }
                            }
                        ]
                    },
                    // добавляем id модели, чтобы потом найти ее при клике на ссылку
                    { elem: 'snippet', content: data.content.map(function(elem) {
                        elem.link_url && (elem.modelId = eventModel.id);

                        return elem;
                    }) }
                ]
            }) :
            undefined;
    },

    /**
     * Проверяет полная ли форма элемента-события имеется в списке
     * @param {BEM.MODEL} eventModel
     * @returns {Boolean}
     * @override
     * @protected
     */
    _isFulfilledItem: function(eventModel) {
        return !!eventModel.get('data');
    },

    /**
     * Предоставляет полные данные по элементу-событию новости
     * @param {BEM.MODEL} eventModel
     * @returns {$.Deferred}
     * @override
     * @protected
     */
    _provideData: function(eventModel) {
        var deferred = $.Deferred();

        this
            ._fetchData(eventModel.get('ext_news_id'))
            .then(function(modelData) {
                eventModel.update(modelData);

                deferred.resolve(eventModel);
            })
            .fail(function() {
                deferred.reject();
            });

        return deferred.promise();
    },

    /**
     * Вытягивает сниппет новости по его идентификатору
     * @param {String} newsId
     * @returns {$.Deferred}
     * @private
     */
    _fetchData: function(newsId) {
        var deferred = $.Deferred();

        BEM.create('i-request_type_ajax', {
            url: this.params.newsFetchURL,
            type: 'GET',
            cache: false,
            dataType: 'json'
        }).get(
            { ext_news_id: newsId },
            function(response) { deferred.resolve(response); },
            function() { deferred.reject(); });

        return deferred;
    },

    /**
     * Обработчик события перехода по ссылке на новости
     * @param {Event} e
     * @private
     */
    _onRead: function(e) {
        var modelId = e.block.params.modelId,
            model = this._items.getById(modelId);

        model.set('read', true);

        this.setMod(this.elem('new-dot', 'model-id', modelId), 'hidden', 'yes');

        window.open(e.block.domElem.attr('href'));
    }
});
