block('b-infoblock').elem('mini')(

    content()(function() {
        var processNewsString = function(sourceString) {
                var words = sourceString.split(' '),
                    newString = '',
                    MAX_LENGTH = 66;

                if (sourceString.length <= MAX_LENGTH) return sourceString;

                for (var i = 0; i < words.length; i++) {
                    var word = words[i],
                        newLength = newString.length + word.length + 1;

                    if (newLength < MAX_LENGTH) {
                        newString += (newString.length ? ' ' : '') + word;
                    } else {
                        break;
                    }
                }

                // убираем знаки препинания из хвоста, ! и ? оставляем
                newString.replace(/(\.|,|\(|")+$/, '');
                return newString + '...';
            },
            teaser = this.ctx.teaser,
            data = this.ctx.news.data,
            news = data && data.content.filter(function(news) {
                return news.text;
            })[0],
            newsText = news && processNewsString($.trim(news.text)),
            title = teaser ?
                u['b-teaser'].getTeaserTitle(teaser.type, teaser.data) :
                news ?
                    iget2('b-infoblock', 'novost-laquo-s-raquo', 'Новость: &laquo;{foo}&raquo;', {
                        foo: newsText
                    }) :
                    iget2('b-infoblock', 'proizoshla-oshibka-poprobuyte-perezagruzit', 'Произошла ошибка. Попробуйте перезагрузить страницу');

        return [
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    theme: 'normal'
                },
                mix: {
                    block: 'b-infoblock',
                    elem: 'teasers-names'
                },
                content: title
            }
        ]
    })
);
