block('b-infoblock')(

    def()(function() {
        return applyNext({
            'mods.pinned': 'no'
        });
    }),

    js()(function() {
        var ctx = this.ctx,
            uid = ctx.uid,
            euid = ctx.euid;

        return {
            uid: uid,
            euid: euid !== uid ? euid : undefined,
            ClientID: ctx.ClientID,
            lang: ctx.lang,
            autoExposeDisabled: ctx.autoExposeDisabled,
            newsUrl: ctx.newsUrl,
            newsFetchURL: ctx.newsFetchURL,
            messagesURL: ctx.messagesURL,
            miniDisabled: ctx.miniDisabled
        };
    }),

    content()(function() {
        return [
            // колокольчик в шапке
            {
                block: 'link',
                mods: {
                    pseudo: 'yes',
                    disabled: 'yes',
                    inner: 'yes',
                    'user-select': 'off'
                },
                mix: [{ block: 'b-infoblock', elem: 'switcher' }],
                attrs: { title: iget2('b-infoblock', 'uvedomleniya', 'Уведомления') },
                content: [
                    { block: 'icon' },
                    {
                        block: 'b-infoblock',
                        elem: 'new-items-balloon',
                        elemMods: { hidden: 'yes' }
                    }
                ]
            },
            // большой попап инфоблока
            {
                block: 'popup',
                js: {
                    directions: {
                        to: 'bottom',
                        offset: {
                            top: 3
                        }
                    }
                },
                mods: {
                    autoclosable: 'yes',
                    scrollable: 'yes',
                    animate: 'yes',
                    adaptive: 'no',
                    'close-theme': 'x',
                    'has-close': 'yes'
                },
                mix: {
                    block: 'b-infoblock',
                    elem: 'popup'
                },
                content: [
                    {
                        elem: 'tail'
                    },
                    {
                        elem: 'content',
                        mix: [{
                            block: 'b-infoblock',
                            elem: 'popup-content'
                        }]
                    }
                ]
            },
            // мини-инфоблок
            {
                block: 'popup',
                mix: [
                    { block: 'b-infoblock', elem: 'mini-popup' }
                ],
                js: {
                    directions: {
                        to: 'bottom',
                        offset: {
                            top: 15
                        }
                    }
                },
                mods: {
                    autoclosable: 'no',
                    scrollable: 'no',
                    animate: 'yes',
                    adaptive: 'no',
                    mini: 'yes',
                    'close-theme': 'x-white',
                    'has-close': 'yes'
                },
                content: {
                    elem: 'content',
                    mix: [{
                        block: 'b-infoblock',
                        elem: 'mini-popup-content'
                    }]
                }
            }
        ];
    }),

    // красный кружок на колокольчике
    elem('new-items-balloon').tag()('span')
);
