/**
 * @param {String} this.params.messagesURL относительный URL до ручки обработки сообщений инфоблока
 * @param {String} this.params.ClientID идентификатор клиента
 * @param {String} this.params.uid идентификатор пользователя
 */
BEM.DOM.decl({ block: 'b-infoblock', baseBlock: 'i-infoblock' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._resize = BEM.blocks['i-resize'].getInstance();

            u.graspSelf.call(this, {
                _switcherLink: 'link on switcher'
            });

            this._setMessagesURL(this.params.messagesURL);
            this._setMetadata({
                uid: this.params.uid,
                euid: this.params.euid,
                ClientID: this.params.ClientID,
                lang: this.params.lang
            });

            this._pageWarningFlags = BEM.MODEL.getOrCreate('m-page-warning-flags');

            this.getNews()
                .then(function(news) {
                    var model = this._createModel(news),
                        showPopup = function() {
                            // задаём атрибут для отображения и поведения как у ссылки
                            this._switcherLink.delMod('disabled');

                            this.setMod('hidden', '');

                            if (this._hasPageWarning()) {
                                // не показываем тизер, но когда плашку скроют, то можно показать
                                this._pageWarningFlags.on('change', function(e, data) {
                                    if (!this._hasPageWarning()) {
                                        // инициируем серую всплывашку
                                        this._initMiniPopup(model);
                                    }
                                }, this);
                            } else {
                                this._initMiniPopup(model);
                            }

                            this._getPopup().elem('close').on('click', function() {
                                this.sendEventMessage('update-last-opened')
                                    .done(function() {
                                        this._getModel().set('expose', false);
                                    }.bind(this));
                            }.bind(this));
                        }.bind(this);

                    showPopup();

                }.bind(this));

            this._subscriptionManager.on(this._switcherLink, 'click', function() {
                this.toggle();
            }, this);
        },

        toggled: {
            yes: function() {
                var model = this._getModel(),
                    popup = this._getPopup(),
                    elements = [];

                // в зависимости от разрешения показывать блоки наполняем список информацией о названии блока,
                // контекстных параметрах блока, о названии поля модели со списком данных, о типе события,
                // с которым будет отправлено сообщение на сервер

                elements.push({
                    block: 'b-infoblock-news',
                    modelField: 'news',
                    ctxParams: {
                        mods: { collapsed: 'no' },
                        newsUrl: this.params.newsUrl,
                        newsFetchURL: this.params.newsFetchURL
                    },
                    messageEventType: 'update-news-state'
                });

                // заполнение контентом и инициализация событий 1 раз при срабатывании переключателя
                popup.setContent(BEMHTML.apply([
                    // всплывает при отстутсвии уведомлений вообще
                    {
                        block: 'b-infoblock',
                        elem: 'noinfo-notification',
                        elemMods: model.get('itemsCount') && { hidden: 'yes' },
                        content: iget2('b-infoblock', 'u-vas-net-uvedomleniy', 'У вас нет уведомлений')
                    },
                    {
                        block: 'b-infoblock',
                        elem: 'header',
                        elemMods: model.get('itemsCount') || { hidden: 'yes' }
                    },
                    elements.map(function(element, index) {
                        var bemjson = element.ctxParams || {},
                            isNotLastAndAlone = index !== elements.length - 1;

                        bemjson.block = element.block;
                        bemjson.mix = [
                            {
                                block: 'b-infoblock',
                                elem: element.modelField,
                                elemMods: {
                                    separated: isNotLastAndAlone ? 'yes' : '',
                                    hidden: model.get('itemsCount') ? '' : 'yes'
                                }
                            }
                        ];

                        return bemjson;
                    })
                ]));

                this._initElementsAndEvents(elements);
            }
        }
    },

    _hasPageWarning: function() {
        return u._.keys(this._pageWarningFlags.toJSON()).some(function(field) {
            return this._pageWarningFlags.get(field);
        }, this)
    },

    /**
     * Показ/скрытие инфоблока
     */
    toggle: function() {
        var popup,
            switcher = this.elem('switcher');

        this.setMod('toggled', 'yes');

        // Закрываем мини-попап, если он есть
        this._miniPopup && this._miniPopup.isShown() && this._miniPopup.hide();

        // перед показом попапа нужно оповестить об этом намерении
        popup = this._getPopup();
        popup.isShown() || this.trigger('opening');

        this.toggleMod(switcher, 'checked', '', 'yes', popup.isShown());

        popup.toggle(switcher);
    },

    /**
     * Уничтожение блока и связанного с ним попапа
     */
    destruct: function() {
        this._subscriptionManager.dispose();

        this._getPopup()
            // нужно скидывать autoclosable для отписки от событий на документе
            .delMod('autoclosable')
            .destruct();

        this._getMiniPopup()
            .delMod('autoclosable')
            .destruct();

        this.__base.apply(this, arguments);
    },

    /**
     * Возвращает модель состояния инфоблока
     * @private
     * @returns {BEM.MODEL}
     */
    _getModel: function() {
        return this._model;
    },

    /**
     * Возвращает попап инфоблока
     * При первом обращении изменяет анимацию попапа
     * @param {Object} options - опции получения попапа
     * @param {Boolean} options.inDestruct - попап получается в процессе destruct-а
     * @private
     * @returns {*|BEM}
     */
    _getPopup: function(options) {
        var popup;

        if (!this._popup) {
            popup = this.findBlockOn('popup', 'popup');

            // изменяем стандартную анимацию попапа, чтобы он всплывал снизу
            // как расположнный рядом дропдаун
            popup.afterShow = this._afterShow.bind(this);
            popup.beforeHide = this._beforeHide.bind(this);

            this._popup = popup;
        }

        return this._popup;
    },

    /**
     * Переставляет попап при ресайзе страницы
     * @private
     */
    _fixPopupPosition: function() {
        var popup = this._getPopup(),
            tail = popup.elem('tail');

        popup.repaint();

        popup.domElem.css({
            left: 'auto',
            right: 0
        });

        tail.css({
            left: 'auto',
            right: this._switcherRightOffset
        });
    },

    /**
     * Анимация на показе инфоблока:
     * а) всплытие снизу
     * б) прибиваем инфоблок к правому краю, сдвигаем хвост
     * в) репозиционировать на ресайзе не надо, дополнительного кода про ресайз - нет
     * @private
     */
    _afterShow: function() {
        var popup = this._getPopup(),
            tail = popup.elem('tail'),
            curPos = popup.getCurrPos();

        if (!this._switcherRightOffset) {
            this._switcherRightOffset = Math.floor(document.documentElement.scrollWidth - popup.getOwnerPos().left +
                (popup.params.tail.width - popup.getOwnerSize().width) / 2);
        }

        tail.css({
            left: 'auto',
            right: this._switcherRightOffset
        });

        popup
            .domElem
            .css({
                left: 'auto',
                right: 0,
                top: curPos.top + 20,
                opacity: 0
            })
            .stop()
            .animate({
                opacity: 1,
                top: curPos.top
            }, 200);

        this._resize.on('start end', this._fixPopupPosition, this);
    },

    /**
     * Анимация на скрытии инфоблока: уезжает вниз
     * @param {Function} callback
     * @private
     */
    _beforeHide: function(callback) {
        this._getPopup().domElem
            .stop()
            .animate({
                top: this._getPopup().getCurrPos().top + 20,
                opacity: 0
            }, 200, callback);

        this._resize.un('start end', this._fixPopupPosition, this);
    },

    /**
     * Возвращает серую всплывашку
     * @returns {*|BEM}
     * @private
     */
    _getMiniPopup: function() {
        return this._miniPopup || (this._miniPopup = this.findBlockOn('mini-popup', 'popup'));
    },

    /**
     * Инициализация серой всплывашки
     * @param {BEM.MODEL} model - модель инфоблока
     * @private
     */
    _initMiniPopup: function(model) {
        var miniPopup,
            newNewsList = model.get('news').where({ new: true }),
            newNews = newNewsList.length && newNewsList[0].toJSON(),
            // иногда от сервера приходят новости с косяками (без data, например)
            needMini = !this._isAutoExposeDisabled() &&
                model.get('hasNewEvents') &&
                (newNews && newNews.data != undefined),
            miniDisabled = this.params.miniDisabled;

        if (!miniDisabled && needMini) {
            miniPopup = this._getMiniPopup();
            miniPopup.setContent(BEMHTML.apply({
                block: 'b-infoblock',
                elem: 'mini',
                news: newNews
            }));

            miniPopup.afterShow = this._afterShowMini.bind(this);
            miniPopup.beforeHide = this._beforeHideMini.bind(this);

            miniPopup.show(this.elem('switcher'));
        }
    },

    /**
     * Переставляет плашку при ресайзе страницы
     * @private
     */
    _fixMiniPopupPosition: function() {
        var miniPopup = this._getMiniPopup();

        miniPopup.repaint();

        miniPopup.domElem.css({
            left: 'auto',
            right: 0
        });
    },

    /**
     * Анимация серой вслывашки
     * Выезжает справа
     * @private
     */
    _afterShowMini: function() {
        var miniPopup = this._getMiniPopup(),
            miniWidth = miniPopup.domElem.width();

        miniPopup
            .domElem
            .css({
                width: 0,
                right: 0,
                left: 'auto',
                opacity: 0
            })
            .stop()
            .animate({
                left: 'auto',
                opacity: 1,
                width: miniWidth
            }, 500);

        this._resize.on('start end', this._fixMiniPopupPosition, this);
    },

    /**
     * Анимация серой всплывашки
     * Уезжает вправо
     * @param {Function} callback
     * @private
     */
    _beforeHideMini: function(callback) {
        this._getMiniPopup().domElem
            .stop()
            .animate({
                width: 0,
                opacity: 0
            }, 500, callback);

        this._resize.un('start end', this._fixMiniPopupPosition, this);
    },

    /**
     * Проверяет, выключено ли автоматическое раскрытие инфоблока или нет
     * @returns {Boolean}
     */
    _isAutoExposeDisabled: function() {
        return this.params.autoExposeDisabled === true;
    },

    /**
     * Создание модели
     * @param {Object} news хеш с элементами инфоблока
     * @returns {BEM.MODEL}
     * @private
     */
    _createModel: function(news) {
        this._model = BEM.MODEL.create('m-infoblock-state');

        this._model
            // обновление красной точки на колокольчике
            .on('hasNewEvents', 'change', function(e, data) {
                var hasNewEvents = data.value,
                    dot = this.elem('new-items-balloon');

                this
                    .toggleMod(dot, 'hidden', 'yes', !hasNewEvents)
                    .toggleMod(this.elem('switcher'), 'unreed', 'yes', hasNewEvents);
            }, this)
            .update({
                news: news
            });

        return this._model;
    },

    /**
     * Инициализирует события блока и его составляющие элементы-события инфоблока
     * @param {Array} elements список параметров для создания блоков элементов-событий
     * @private
     */
    _initElementsAndEvents: function(elements) {
        var model = this._getModel(),
            popup = this._getPopup(),
            pinner = popup.findBlockInside(this.elem('pinner'), 'link');

        // инициализация блоков элементов-событий инфоблока
        elements.forEach(function(element) {
            var field = element.modelField,
                block = this.findBlockOn(field, element.block);

            // инициализация событий обновления состояния тизера/новости
            this._initStateChangeEvents(field, element.messageEventType);

            // при каждом открытии инфоблока нужно перерисовать содержимое блока элемента-события
            this._subscriptionManager.on(this, 'opening', function() {
                block.repaint(model.get(field));
            });
        }, this);

        // при открытии нужно стриггерить событие change для блоков с i-glue (после отрисовки блоков элементов-событий)
        this._subscriptionManager
            .on(this, 'opening', function() {
                var popup;

                // если нет элементов - показываем noinfo
                if (!model.get('itemsCount')) {
                    popup = this._getPopup();

                    this.delMod(this.findElem(popup.domElem, 'noinfo-notification'), 'hidden', 'yes');
                }
            })
            .on(popup, 'hide', function() {
                this.delMod(this.elem('switcher'), 'checked');
            }, this)
            // пиннер убирает автозакрытие по клику на страницу
            .on(pinner, 'click', function() {
                this.toggleMod('autoclosable', 'yes', '');
                pinner.toggleMod('pinned', 'yes', 'no');
            }, popup);
    },

    /**
     * События при изменении состояния тизера или новости
     * @param {String} field - поле (news)
     * @param {String} eventType - название события (update-news-state)
     * @returns {BEM.DOM}
     * @private
     */
    _initStateChangeEvents: function(field, eventType) {
        var modelName = this._model.getFieldModelName(field);

        if (field === 'news') {
            this._subscriptionManager.wrap(BEM.MODEL)
                // событие просмотра тизера/новости (возникает после перехода по ссылке)
                .on(modelName, 'read', 'change', function(event) {
                    var eventModel = event.target.model;

                    this.sendEventMessage(eventType, eventModel.toJSON()).done(function() {
                        eventModel.set('new', false);
                    });
                }, this);
        }

        return this;
    }
});
