block('b-internal-search-form')(

    tag()('form'),

    attrs()(function() {
        return {
            action: u.getUrl('internalAdsSearch'),
            method: 'GET'
        };
    }),

    elem('rows').content()(function() {
        return [
            {
                block: 'input',
                mods: { type: 'hidden' },
                name: 'cmd',
                value: 'internalAdsSearch'
            },
            {
                block: 'b-layout-table',
                content: [
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'search-type-row',
                                        value: this.ctx.data.searchType
                                    },
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'criteria-type-row',
                                        values: this.ctx.data.criteriaTypes
                                    },
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'criteria-input-rows',
                                        values: this.ctx.data.criteriaInputs
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        elem: 'row',
                        content: [
                            {
                                elem: 'cell',
                                content: [
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'row',
                                        elemMods: { type: 'separator' }
                                    },
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'criteria-flags-rows',
                                        values: this.ctx.data.criteriaFlags
                                    },
                                    {
                                        block: 'b-internal-search-form',
                                        elem: 'search-bar-row'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    }),

    elem('criteria-flags-rows').content()(function() {
        return this.ctx.values.reduce(function(rows, value) {
            return rows.concat(value.variants.map(function(variant) {
                return {
                    elem: 'row',
                    elemMods: {
                        'search-type': u.beminize(value.key),
                        'criteria-flag': u.beminize(variant.name),
                        hidden: value.disabled || variant.disabled ? 'yes' : 'no'
                    },
                    content: [
                        { elem: 'label' },
                        {
                            block: 'checkbox',
                            mods: {
                                checked: variant.value ? 'yes' : '',
                                disabled: value.disabled || variant.disabled ? 'yes' : ''
                            },
                            mix: [{
                                block: 'b-internal-search-form',
                                elem: 'criteria-checkbox',
                                elemMods: {
                                    'search-type': u.beminize(value.key)
                                }
                            }],
                            checkboxAttrs: { name: variant.name },
                            text: variant.desc
                        }
                    ]
                };
            }));
        }, []);
    }),

    elem('criteria-input-rows').content()(function() {
        return this.ctx.values.map(function(input) {
            return {
                elem: 'row',
                elemMods: {
                    'search-type': u.beminize(input.key),
                    hidden: input.disabled ? 'yes' : 'no'
                },
                content: [
                    {
                        elem: 'label',
                        content: input.welcomes.map(function(variant) {
                            return {
                                elem: 'search-label',
                                elemMods: {
                                    'criteria-type': u.beminize(variant.criteria),
                                    hidden: input.disabled || variant.disabled ? 'yes' : 'no'
                                },
                                content: variant.desc
                            };
                        })
                    },
                    {
                        block: 'input',
                        mods: { disabled: input.disabled ? 'yes' : '' },
                        mix: {
                            block: 'b-internal-search-form',
                            elem: 'criteria-input',
                            elemMods: { 'search-type': u.beminize(input.key) }
                        },
                        name: input.name,
                        value: input.value,
                        content: { elem: 'control' }
                    }
                ]
            };
        });
    }),

    elem('criteria-type-row').content()(function() {
        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-internal-search-form', 'criteria-type-label', 'Критерий') + ':'
                }
            ].concat(this.ctx.values.map(function(item) {
                return {
                    block: 'radiobox',
                    mods: { disabled: item.disabled ? 'yes' : '' },
                    mix: {
                        block: 'b-internal-search-form',
                        elem: 'criteria-type',
                        elemMods: { key: u.beminize(item.key) }
                    },
                    name: item.name,
                    value: item.value,
                    content: item.variants.map(function(variant) {
                        return {
                            elem: 'radio',
                            mix: { block: 'b-internal-search-form', elem: 'radio' },
                            controlAttrs: { value: variant.value },
                            content: variant.desc
                        };
                    })
                };
            }))
        };
    }),

    elem('search-type-row').content()(function() {
        return {
            elem: 'row',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-internal-search-form', 'search-type-label', 'Искать по') + ':'
                },
                {
                    block: 'radio-button',
                    mix: [{ block: 'b-internal-search-form', elem: 'search-type' }],
                    name: this.ctx.value.name,
                    value: this.ctx.value.value,
                    content: this.ctx.value.variants.map(function(variant) {
                        return {
                            elem: 'radio',
                            controlAttrs: { value: variant.value },
                            content: variant.desc
                        };
                    })
                }
            ]
        };
    }),

    elem('search-bar-row').content()(function() {
        return {
            block: 'b-internal-search-form',
            elem: 'row',
            elemMods: { type: 'search-bar' },
            content: [
                {
                    elem: 'label'
                },
                {
                    block: 'button',
                    mods: {
                        disabled: 'yes'
                    },
                    mix: { block: 'b-internal-search-form', elem: 'submit' },
                    type: 'submit',
                    content: iget2('b-internal-search-form', 'find-button', 'Найти')
                }
            ]
        };
    })
);
