block('b-internal-search-form')(
    def()(function() {
        return applyNext({
            'ctx.criteriaFlags': {
                exactMatch: 'exact_match',
                includeInactiveAds: 'include_inactive_ads',
                includeInactiveCampaigns: 'include_inactive_campaigns'
            }
        });
    }),

    addJs()(function() {
        return {
            criteriaFlags: this.ctx.criteriaFlags
        };
    }),

    mode('search-type-value')(function() {
        var form = this.data.FORM;

        return form.object_type && form.object_type.toString() || 'campaigns';
    }),

    mode('search-type')(function() {
        return {
            name: 'object_type',
            value: apply('search-type-value'),
            variants: [
                {
                    value: 'campaigns',
                    desc: iget2('b-internal-search-form', 'search-by-campaigns', 'Кампании')
                },
                {
                    value: 'adgroups',
                    desc: iget2('b-internal-search-form', 'search-by-adgroups', 'Группы объявлений')
                },
                {
                    value: 'ads',
                    desc: iget2('b-internal-search-form', 'search-by-ads', 'Объявления')
                }
            ]
        };
    }),

    mode('criteria')(function() {
        var form = this.data.FORM;

        return (form.criteria || '').trim();
    }),

    mode('criteria-inputs')(function() {
        return apply('criteria-types').map(function(type) {
            return {
                key: type.key,
                disabled: type.disabled,
                name: 'criteria',
                value: !type.disabled ? apply('criteria') : '',
                welcomes: type.variants.map(function(variant) {
                    return {
                        criteria: variant.value,
                        disabled: type.value !== variant.value,
                        desc: variant.value === 'all_ad_fields' ?
                            iget2('b-internal-search-form', 'search-label', 'искать') :
                            variant.desc
                    };
                })
            };
        }, this);
    }),

    mode('criteria-types')(function() {
        var form = this.data.FORM;
        var searchType = apply('search-type-value');
        var names = {
            campaigns: 'campaigns_criteria_type',
            groups: 'adgroups_criteria_type',
            ads: 'ads_criteria_type'
        };

        return [
            {
                key: 'campaigns',
                name: names.campaigns,
                value: form[names.campaigns] || 'cids',
                disabled: searchType !== 'campaigns',
                variants: [
                    {
                        value: 'cids',
                        desc: iget2('b-internal-search-form', 'campaigns-numbers-criteria', 'номера кампаний')
                    },
                    {
                        value: 'order_ids',
                        desc: iget2('b-internal-search-form', 'campaigns-order-ids-criteria', 'номера кампаний (БК)')
                    },
                    {
                        value: 'campaign_name',
                        desc: iget2('b-internal-search-form', 'campaign-name-criteria', 'название кампании')
                    },
                    {
                        value: 'places',
                        desc: iget2('b-internal-search-form', 'places-criteria', 'плейсы')
                    },
                    {
                        value: 'products',
                        desc: iget2('b-internal-search-form', 'products-criteria', 'продукты')
                    }
                ]
            },
            {
                key: 'adgroups',
                name: names.groups,
                value: form[names.groups] || 'pids',
                disabled: searchType !== 'adgroups',
                variants: [
                    {
                        value: 'pids',
                        desc: iget2('b-internal-search-form', 'groups-numbers-criteria', 'номера групп')
                    },
                    {
                        value: 'group_name',
                        desc: iget2('b-internal-search-form', 'group-name-criteria', 'название группы')
                    }
                ]
            },
            {
                key: 'ads',
                name: names.ads,
                value: form[names.ads] || 'bids',
                disabled: searchType !== 'ads',
                variants: [
                    {
                        value: 'bids',
                        desc: iget2('b-internal-search-form', 'ads-numbers-criteria', 'номера объявлений')
                    },
                    {
                        value: 'banner_ids',
                        desc: iget2('b-internal-search-form', 'banners-ids-criteria', 'номера объявлений (БК)')
                    },
                    {
                        value: 'count_link',
                        desc: iget2('b-internal-search-form', 'count-link-criteria', 'count-ссылка')
                    },
                    {
                        value: 'all_ad_fields',
                        desc: iget2('b-internal-search-form', 'ads-all-fields-criteria', 'все поля')
                    }
                ]
            }
        ];
    }),

    mode('criteria-flags')(function() {
        var form = this.data.FORM;
        var searchType = apply('search-type-value');
        var criteriaFlags = this.ctx.criteriaFlags;
        var labels = {
            exactMatch: iget2('b-internal-search-form', 'exact-match-flag', 'точное соответствие'),
            includeInactiveAds: iget2('b-internal-search-form', 'include-inactive-ads-flag', 'включая неактивные объявления'),
            includeInactiveCampaigns: iget2('b-internal-search-form', 'include-inactive-campaigns-flag', 'включая неактивные кампании')
        };

        return apply('criteria-types').map(function(type) {
            var disabledFlags = u['b-internal-search-form'].getDisabledFlags(searchType, type.value);
            var flags = [
                'includeInactiveCampaigns',
                type.key === 'ads' && 'includeInactiveAds',
                'exactMatch'
            ].filter(Boolean);

            return {
                key: type.key,
                disabled: type.disabled,
                variants: flags.map(function(flag) {
                    return {
                        value: !type.disabled ? form[criteriaFlags[flag]] : '',
                        name: criteriaFlags[flag],
                        disabled: disabledFlags[flag],
                        desc: labels[flag]
                    };
                })
            };
        });
    }),

    content()(function() {
        return {
            block: 'b-internal-search-form',
            elem: 'rows',
            data: {
                searchType: apply('search-type'),
                criteriaTypes: apply('criteria-types'),
                criteriaInputs: apply('criteria-inputs'),
                criteriaFlags: apply('criteria-flags')
            }
        };
    })
);
