BEM.DOM.decl('b-internal-search-form', {

    onSetMod: {
        js: function() {
            this._searchTypeRadio = this.findBlockOn('search-type', 'radio-button');
            this._criteriaTypeRadioboxes = this.findBlocksOn('criteria-type', 'radiobox');
            this._criteriaInputs = this.findBlocksOn('criteria-input', 'input');
            this._criteriaCheckboxes = this.findBlocksOn('criteria-checkbox', 'checkbox');
            this._submitButton = this.findBlockOn('submit', 'button');

            this._subscriptions = BEM.create('i-subscription-manager');
            this._subscriptions.on(this._searchTypeRadio, 'change', function() {
                this._updateBySearchType();
            }, this);

            this.bindTo('submit', function() {
                this._submitButton.setMod('disabled', 'yes');

                this.trigger('submit');
            });

            this._criteriaTypeRadioboxes.forEach(function(block) {
                this._subscriptions.on(block, 'change', function() {
                    this._updateByCriteriaType();
                }, this);
            }, this);

            this._criteriaInputs.forEach(function(block) {
                this._subscriptions.on(block, 'change', function(e) {
                    this._updateSubmitButton(e.block.val());
                }, this);
            }, this);

            this._updateBySearchType();
        }
    },

    destruct: function() {
        this._subscriptions.dispose();
        this._subscriptions.destruct();

        this.__base.apply(this, arguments);
    },

    _getCriteriaFlagRow: function(searchType, criteriaFlag) {
        var searchTypeRow = this.elem('row', 'search-type', u.beminize(searchType));

        return this.findElem(searchTypeRow, 'row', 'criteria-flag', u.beminize(criteriaFlag));
    },

    _getCriteriaTypeRadioboxes: function(searchType) {
        var elem = this.elem('criteria-type', 'key', u.beminize(searchType));

        return this.findBlockOn(elem, 'radiobox');
    },

    _getCriteriaInput: function(searchType) {
        var elem = this.elem('criteria-input', 'search-type', u.beminize(searchType));

        return this.findBlockOn(elem, 'input');
    },

    _toggleRows: function(searchType) {
        this.setMod(this.elem('row', 'hidden', 'no'), 'hidden', 'yes');
        this.setMod(this.elem('row', 'search-type', u.beminize(searchType)), 'hidden', 'no');
    },

    _toggleSearchLabel: function(criteriaType) {
        this.setMod(this.elem('search-label', 'hidden', 'no'), 'hidden', 'yes');
        this.setMod(this.elem('search-label', 'criteria-type', u.beminize(criteriaType)), 'hidden', 'no');
    },

    _toggleFlags: function(searchType, criteriaType) {
        var checkboxesAllowed = this.findBlocksOn(
            this.elem('criteria-checkbox', 'search-type', u.beminize(searchType)),
            'checkbox'
            ),
            disabledFlags = u['b-internal-search-form'].getDisabledFlags(searchType, criteriaType),
            criteriaFlags = this.params.criteriaFlags,
            flags = ['exactMatch', 'includeInactiveCampaigns', 'includeInactiveAds'];

        this._criteriaCheckboxes.forEach(function(block) {
            block.setMod('disabled', 'yes');
        });

        checkboxesAllowed.forEach(function(block) {
            var skipEnable = flags.some(function(flag) {
                return disabledFlags[flag] && block.val() === criteriaFlags[flag];
            }, this);

            if (!skipEnable) {
                block.delMod('disabled');
            }
        }, this);

        flags.forEach(function(flag) {
            this.toggleMod(
                this._getCriteriaFlagRow(searchType, criteriaFlags[flag]),
                'hidden',
                'yes',
                'no',
                disabledFlags[flag]
            );
        }, this);
    },

    _updateSubmitButton: function(criteria) {
        this._submitButton.toggleMod('disabled', 'yes', !(criteria || '').trim());
    },

    _updateByCriteriaType: function() {
        var searchType = this._searchTypeRadio.val(),
            criteriaType = this.findBlockOn(
                this.elem('criteria-type', 'key', u.beminize(searchType)),
                'radiobox'
            ).val();

        this._toggleSearchLabel(criteriaType);
        this._toggleFlags(searchType, criteriaType);
    },

    _updateBySearchType: function() {
        var searchType = this._searchTypeRadio.val();

        this._criteriaInputs.forEach(function(block) {
            block.setMod('disabled', 'yes');
        });

        this._getCriteriaInput(searchType).delMod('disabled');

        this._criteriaTypeRadioboxes.forEach(function(block) {
            block.setMod('disabled', 'yes');
        });

        this._getCriteriaTypeRadioboxes(searchType).delMod('disabled');

        this._toggleRows(searchType);

        this._updateByCriteriaType();

        this._updateSubmitButton(this._getCriteriaInput(searchType).val());
    }

});
