block('b-ip-list-item')(
    mix()(function() {
        return {
            block: 'i-glue',
            js: {
                modelParams: {
                    name: 'm-ip-item',
                    id: this.ctx.data.id
                }
            }
        };
    }),

    content()(function() {
        var data = this.ctx.data,
            type = this.ctx.type;

        return [
            {
                block: 'input',
                value: data.ip,
                name: 'contact',
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'ip',
                        type: 'input'
                    }
                },
                content: [
                    { elem: 'control' },
                    {
                        elem: 'note',
                        content: iget2('b-ip-list-item', 'adres', 'адрес')
                    }
                ]
            },
            { elem: 'input-separator' },
            {
                block: 'input',
                value: data.mask,
                name: 'contact',
                mix: {
                    block: 'i-glue',
                    elem: 'model-field',
                    js: {
                        name: 'mask',
                        type: 'input'
                    }
                },
                content: [
                    { elem: 'control' },
                    {
                        elem: 'note',
                        content: iget2('b-ip-list-item', 'maska', 'маска')
                    }
                ]
            },
            {
                elem: 'controls',
                content: [
                    {
                        elem: 'add',
                        modelId: data.id,
                        elemMods: {
                            disabled: type === 'single' || type === 'trailer' ? '' : 'yes'
                        }
                    },
                    {
                        elem: 'remove',
                        modelId: data.id,
                        elemMods: {
                            disabled: type === 'trailer' || type === 'last' ? '' : 'yes'
                        }
                    }
                ]
            }
        ];
    })
);
