BEM.DOM.decl('b-ip-list', {
    onSetMod: {
        js: function() {
            this.model = BEM.MODEL.getOrCreate('m-ip-list');

            BEM.DOM.blocks['link'].on(this.domElem, 'click', function(event) {
                var params = (this.elemParams(this.findElem(event.target.domElem, 'action')) || {}),
                    handler = ({
                        'edit-ip-list': this._showIpList,
                        'add-field': this._addField,
                        'remove-field': this._removeField
                    })[params.action];

                handler && handler.call(this, params.modelId);
            }, this);

            this.model.on('items', 'change', function(e, data) {
                // если обновляется элемент списка, а не сам список, то в дате есть атрибут value
                if (typeof data.value === 'undefined') this._updateListState();

                this.model.updateAllowedIps();
            }, this);
        }
    },

    /**
     * Показывает новый список ip адресов
     * @private
     */
    _showIpList: function() {
        this._addField();
    },

    /**
     * Обрабатывает добавление поля списка адресов.
     *
     * @private
     */
    _addField: function() {
        this.model.get('items').add({ id: $.identify(), ip: '' });
    },

    /**
     * Обрабатывает удаление поля списка адресов.
     *
     * @private
     */
    _removeField: function(id) {
        this.model.get('items').remove(id);
    },

    /**
     * Обновляет состояние список адресов.
     *
     * @private
     */
    _updateListState: function() {
        BEM.DOM.update(
            this.domElem,
            BEMHTML.apply({
                block: 'b-ip-list',
                elem: 'list',
                items: this.model.get('items').map(function(item) {
                    return item.toJSON();
                })
            }));
    }
});
