/**
 * @typedef {Object} SelectedListItemData параметры элемента для добавления в список
 * @property {BEMJSON} content содержимое элемента
 * @property {String} id идентификатор элемента
 * @property {Number} [orderIndex] порядковый индекс (для определения позиции элемента в списке)
 */
BEM.DOM.decl('b-items-list', {
    onSetMod: {
        js: function() {
            this._items = [];
        }
    },

    /**
     * Добавляет элемент в список
     * @param {SelectedListItemData} item
     */
    addItem: function(item) {
        var prev,
            itemHtml = $(BEMHTML.apply({
                block: 'b-selected-items-list',
                elem: 'item',
                js: { id: item.id },
                content: item.content
            })),
            cache = this._items,
            target = this.domElem,
            itemData = {
                id: item.id,
                html: itemHtml
            };

        // вставляем в соответсвии с порядковым номером, если он указан
        // и в начало - если нет
        if (item.orderIndex) {
            for (var i = item.orderIndex - 1; i >= 0; i--) {
                if (cache[i]) {
                    prev = cache[i].html;
                    break;
                }
            }

            cache[item.orderIndex] ? cache.splice(item.orderIndex, 0, itemData) : cache[item.orderIndex] = itemData;
        } else {
            cache.unshift(itemData);
        }

        if (prev) {
            BEM.DOM.after(prev, itemData.html);
        } else {
            BEM.DOM.prepend(target, itemData.html);
        }
    },

    /**
     * Добавляет элементы в список
     * @param {SelectedListItemData[]} items
     */
    addItems: function(items) {
        items.forEach(function(item) {
            this.addItem(item);
        }, this);
    },

    /**
     * Удаляет элемент из списка
     * @param {String} itemId идентификатор элемента
     */
    removeItem: function(itemId) {
        var itemIndex = u._.findIndex(this._items, function(item) {
            return item && item.id == itemId;
        });

        if (itemIndex !== -1) {
            this._items[itemIndex].html.remove();
            this._items[itemIndex] = null;
        }
    },

    /**
     * Очищает список
     */
    clear: function() {
        this._items = [];
        this.domElem.innerHtml = '';
    }
});
